/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;

public abstract class JSAbstractBuffer
extends JSNonProxy {
    protected static final String BYTE_LENGTH = "byteLength";

    protected JSAbstractBuffer() {
    }

    public static byte[] getByteArray(DynamicObject thisObj) {
        assert (JSAbstractBuffer.isJSAbstractHeapBuffer(thisObj));
        return JSArrayBufferObject.getByteArray(thisObj);
    }

    public static int getByteLength(DynamicObject thisObj) {
        assert (JSAbstractBuffer.isJSAbstractHeapBuffer(thisObj));
        return JSAbstractBuffer.getByteArray(thisObj).length;
    }

    public static boolean isJSAbstractHeapBuffer(Object obj) {
        return JSArrayBuffer.isJSHeapArrayBuffer(obj);
    }

    public static boolean isJSAbstractBuffer(Object obj) {
        return JSArrayBuffer.isJSHeapArrayBuffer(obj) || JSArrayBuffer.isJSDirectArrayBuffer(obj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(obj);
    }
}

