/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.callback.OnReadInlineContent;
import org.apache.olingo.odata2.api.ep.callback.ReadEntryResult;
import org.apache.olingo.odata2.api.ep.callback.ReadFeedResult;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityTypeMapping;
import org.apache.olingo.odata2.core.ep.consumer.XmlPropertyConsumer;
import org.apache.olingo.odata2.core.ep.entry.EntryMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.MediaMetadataImpl;
import org.apache.olingo.odata2.core.ep.entry.ODataEntryImpl;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;
import org.apache.olingo.odata2.core.ep.feed.ODataDeltaFeedImpl;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeNodeImpl;

public class XmlEntryConsumer {
    private ODataEntryImpl readEntryResult;
    private Map<String, Object> properties;
    private MediaMetadataImpl mediaMetadata;
    private EntryMetadataImpl entryMetadata;
    private ExpandSelectTreeNodeImpl expandSelectTree;
    private EntityTypeMapping typeMappings;
    private String currentHandledStartTagName;

    public ODataEntry readEntry(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties, boolean isInline) throws EntityProviderException {
        try {
            this.initialize(readProperties);
            if (isInline) {
                this.setETag(reader);
            }
            while (reader.hasNext() && !this.isEntryEndTag(reader)) {
                reader.nextTag();
                if (!reader.isStartElement()) continue;
                this.handleStartedTag(reader, eia, readProperties);
            }
            return this.readEntryResult;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private boolean isEntryEndTag(XMLStreamReader reader) {
        return reader.isEndElement() && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()) && "entry".equals(reader.getLocalName());
    }

    private void initialize(EntityProviderReadProperties readProperties) throws EntityProviderException {
        this.properties = new HashMap<String, Object>();
        this.mediaMetadata = new MediaMetadataImpl();
        this.entryMetadata = new EntryMetadataImpl();
        this.expandSelectTree = new ExpandSelectTreeNodeImpl();
        this.readEntryResult = new ODataEntryImpl(this.properties, this.mediaMetadata, this.entryMetadata, this.expandSelectTree);
        this.typeMappings = EntityTypeMapping.create(readProperties.getTypeMappings());
    }

    private void handleStartedTag(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        this.currentHandledStartTagName = reader.getLocalName();
        if ("id".equals(this.currentHandledStartTagName)) {
            this.readId(reader);
        } else if ("entry".equals(this.currentHandledStartTagName)) {
            this.readEntry(reader);
        } else if ("link".equals(this.currentHandledStartTagName)) {
            this.readLink(reader, eia, readProperties);
        } else if ("content".equals(this.currentHandledStartTagName)) {
            this.readContent(reader, eia, readProperties);
        } else if ("properties".equals(this.currentHandledStartTagName)) {
            this.readProperties(reader, eia, readProperties);
        } else if (!readProperties.getMergeSemantic()) {
            this.readCustomElement(reader, this.currentHandledStartTagName, eia, readProperties);
        } else {
            this.skipStartedTag(reader);
        }
    }

    private void readCustomElement(XMLStreamReader reader, String tagName, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) throws EdmException, EntityProviderException, XMLStreamException {
        EntityPropertyInfo targetPathInfo = eia.getTargetPathInfo(tagName);
        NamespaceContext nsctx = reader.getNamespaceContext();
        boolean skipTag = true;
        if (!"http://www.w3.org/2005/Atom".equals(reader.getName().getNamespaceURI())) {
            if (targetPathInfo != null) {
                String customPrefix = targetPathInfo.getCustomMapping().getFcNsPrefix();
                String customNamespaceURI = targetPathInfo.getCustomMapping().getFcNsUri();
                if (customPrefix != null && customNamespaceURI != null) {
                    String xmlPrefix = nsctx.getPrefix(customNamespaceURI);
                    String xmlNamespaceUri = reader.getNamespaceURI(customPrefix);
                    if (customNamespaceURI.equals(xmlNamespaceUri) && customPrefix.equals(xmlPrefix)) {
                        skipTag = false;
                        reader.require(1, customNamespaceURI, tagName);
                        String text = reader.getElementText();
                        reader.require(2, customNamespaceURI, tagName);
                        EntityPropertyInfo propertyInfo = this.getValidatedPropertyInfo(eia, tagName);
                        Class typeMapping = this.typeMappings.getMappingClass(propertyInfo.getName());
                        EdmSimpleType type = (EdmSimpleType)propertyInfo.getType();
                        Object value = type.valueOfString(text, EdmLiteralKind.DEFAULT, (EdmFacets)(readProperties == null || readProperties.isValidatingFacets() ? propertyInfo.getFacets() : null), typeMapping == null ? type.getDefaultType() : typeMapping);
                        this.properties.put(tagName, value);
                    }
                }
            } else {
                throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(new Object[]{tagName}));
            }
        }
        if (skipTag) {
            this.skipStartedTag(reader);
        }
    }

    private void skipStartedTag(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getLocalName();
        int read = 1;
        while (read > 0 && reader.hasNext()) {
            reader.next();
            if (!reader.hasName() || !name.equals(reader.getLocalName())) continue;
            if (reader.isEndElement()) {
                --read;
                continue;
            }
            if (!reader.isStartElement()) continue;
            ++read;
        }
    }

    private void readEntry(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "entry");
        this.setETag(reader);
    }

    private void setETag(XMLStreamReader reader) {
        String etag = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag");
        this.entryMetadata.setEtag(etag);
    }

    private void readLink(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        reader.require(1, "http://www.w3.org/2005/Atom", "link");
        String rel = reader.getAttributeValue(null, "rel");
        String uri = reader.getAttributeValue(null, "href");
        String type = reader.getAttributeValue(null, "type");
        String etag = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag");
        reader.require(1, "http://www.w3.org/2005/Atom", "link");
        reader.nextTag();
        if (rel == null || uri == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"href' and/or 'rel"}).addContent(new Object[]{"link"}));
        }
        if (rel.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) {
            String navigationPropertyName = rel.substring("http://schemas.microsoft.com/ado/2007/08/dataservices/related/".length());
            this.entryMetadata.putAssociationUri(navigationPropertyName, uri);
        } else if (rel.equals("edit-media")) {
            this.mediaMetadata.setEditLink(uri);
            this.mediaMetadata.setEtag(etag);
        }
        if (!reader.isEndElement() && rel != null && rel.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) {
            this.readInlineContent(reader, eia, readProperties, type, rel);
        }
    }

    private void readInlineContent(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties, String atomLinkType, String atomLinkRel) throws XMLStreamException, EntityProviderException, EdmException {
        String navigationPropertyName = atomLinkRel.substring("http://schemas.microsoft.com/ado/2007/08/dataservices/related/".length());
        EdmNavigationProperty navigationProperty = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
        EdmEntitySet entitySet = eia.getEntitySet().getRelatedEntitySet(navigationProperty);
        EntityInfoAggregator inlineEia = EntityInfoAggregator.create(entitySet);
        EntityProviderReadProperties inlineProperties = this.createInlineProperties(readProperties, navigationProperty);
        boolean isFeed = this.isInlineFeedValidated(reader, eia, atomLinkType, navigationProperty);
        ArrayList<ODataEntry> inlineEntries = new ArrayList<ODataEntry>();
        while (!(reader.isEndElement() && "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(reader.getNamespaceURI()) && "inline".equals(reader.getLocalName()))) {
            if (reader.isStartElement() && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()) && "entry".equals(reader.getLocalName())) {
                XmlEntryConsumer xec = new XmlEntryConsumer();
                ODataEntry inlineEntry = xec.readEntry(reader, inlineEia, inlineProperties, true);
                inlineEntries.add(inlineEntry);
            }
            reader.next();
        }
        this.updateExpandSelectTree(navigationPropertyName, inlineEntries);
        this.updateReadProperties(readProperties, navigationPropertyName, navigationProperty, isFeed, inlineEntries);
        reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
    }

    private void updateReadProperties(EntityProviderReadProperties readProperties, String navigationPropertyName, EdmNavigationProperty navigationProperty, boolean isFeed, List<ODataEntry> inlineEntries) throws EntityProviderException {
        Object entry = this.extractODataEntity(isFeed, inlineEntries);
        OnReadInlineContent callback = readProperties.getCallback();
        if (callback == null) {
            this.readEntryResult.setContainsInlineEntry(true);
            this.properties.put(navigationPropertyName, entry);
        } else {
            this.doCallback(readProperties, navigationProperty, callback, isFeed, entry);
        }
    }

    private void updateExpandSelectTree(String navigationPropertyName, List<ODataEntry> inlineEntries) throws EntityProviderException {
        this.expandSelectTree.setExpanded();
        ExpandSelectTreeNodeImpl subNode = this.getExpandSelectTreeNode(inlineEntries);
        this.expandSelectTree.putLink(navigationPropertyName, subNode);
        for (ODataEntry entry : inlineEntries) {
            ExpandSelectTreeNodeImpl newExpandedSelectedTree = new ExpandSelectTreeNodeImpl();
            newExpandedSelectedTree.setExpanded();
            newExpandedSelectedTree.setExplicitlySelected();
            newExpandedSelectedTree.putLink(navigationPropertyName, (ExpandSelectTreeNodeImpl)entry.getExpandSelectTree());
            this.expandSelectTree.getExpandedList().add(newExpandedSelectedTree);
        }
    }

    private ExpandSelectTreeNodeImpl getExpandSelectTreeNode(List<ODataEntry> inlineEntries) throws EntityProviderException {
        if (inlineEntries.isEmpty()) {
            return new ExpandSelectTreeNodeImpl();
        }
        ExpandSelectTreeNode inlinedEntryEstNode = inlineEntries.get(0).getExpandSelectTree();
        if (inlinedEntryEstNode instanceof ExpandSelectTreeNodeImpl) {
            return (ExpandSelectTreeNodeImpl)inlinedEntryEstNode;
        }
        throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Unsupported implementation for " + ExpandSelectTreeNode.class + " found."}));
    }

    private Object extractODataEntity(boolean isFeed, List<ODataEntry> inlineEntries) {
        if (isFeed) {
            return new ODataDeltaFeedImpl(inlineEntries, new FeedMetadataImpl());
        }
        if (!inlineEntries.isEmpty()) {
            return inlineEntries.get(0);
        }
        return null;
    }

    private void doCallback(EntityProviderReadProperties readProperties, EdmNavigationProperty navigationProperty, OnReadInlineContent callback, boolean isFeed, Object content) throws EntityProviderException {
        try {
            if (isFeed) {
                ReadFeedResult callbackInfo = new ReadFeedResult(readProperties, navigationProperty, (ODataFeed)content, this.entryMetadata.getId());
                callback.handleReadFeed(callbackInfo);
            } else {
                ReadEntryResult callbackInfo = new ReadEntryResult(readProperties, navigationProperty, (ODataEntry)content, this.entryMetadata.getId());
                callback.handleReadEntry(callbackInfo);
            }
        }
        catch (ODataApplicationException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private EntityProviderReadProperties createInlineProperties(EntityProviderReadProperties readProperties, EdmNavigationProperty navigationProperty) throws EntityProviderException {
        OnReadInlineContent callback = readProperties.getCallback();
        EntityProviderReadProperties currentReadProperties = EntityProviderReadProperties.initFrom((EntityProviderReadProperties)readProperties).build();
        if (callback == null) {
            return currentReadProperties;
        }
        try {
            return callback.receiveReadProperties(currentReadProperties, navigationProperty);
        }
        catch (ODataApplicationException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private boolean isInlineFeedValidated(XMLStreamReader reader, EntityInfoAggregator eia, String type, EdmNavigationProperty navigationProperty) throws EntityProviderException, EdmException {
        boolean isFeed = false;
        try {
            reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            ContentType cType = ContentType.parse(type);
            if (cType == null) {
                throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"xml data"}));
            }
            EdmMultiplicity navigationMultiplicity = navigationProperty.getMultiplicity();
            switch (navigationMultiplicity) {
                case MANY: {
                    this.validateFeedTags(reader, cType);
                    isFeed = true;
                    break;
                }
                case ONE: 
                case ZERO_TO_ONE: {
                    this.validateEntryTags(reader, cType);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"xml data"}), (Throwable)e);
        }
        return isFeed;
    }

    private void validateEntryTags(XMLStreamReader reader, ContentType cType) throws XMLStreamException, EntityProviderException {
        if ("entry".equals(cType.getParameters().get("type"))) {
            int next = reader.nextTag();
            if (1 == next) {
                reader.require(1, "http://www.w3.org/2005/Atom", "entry");
            } else {
                reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"entry"}));
        }
    }

    private void validateFeedTags(XMLStreamReader reader, ContentType cType) throws XMLStreamException, EntityProviderException {
        if ("feed".equals(cType.getParameters().get("type"))) {
            int next = reader.nextTag();
            if (1 == next) {
                reader.require(1, "http://www.w3.org/2005/Atom", "feed");
            } else {
                reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_INLINE_CONTENT.addContent(new Object[]{"feed"}));
        }
    }

    private void readContent(XMLStreamReader reader, EntityInfoAggregator eia, EntityProviderReadProperties readProperties) throws EntityProviderException, XMLStreamException, EdmException {
        reader.require(1, "http://www.w3.org/2005/Atom", "content");
        String contentType = reader.getAttributeValue(null, "type");
        String sourceLink = reader.getAttributeValue(null, "src");
        reader.nextTag();
        if (reader.isStartElement() && reader.getLocalName().equals("properties")) {
            this.readProperties(reader, eia, readProperties);
        } else if (reader.isEndElement()) {
            reader.require(2, "http://www.w3.org/2005/Atom", "content");
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Expected closing 'content' or starting 'properties' but found '" + reader.getLocalName() + "'."}));
        }
        this.mediaMetadata.setContentType(contentType);
        this.mediaMetadata.setSourceLink(sourceLink);
    }

    private void readId(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "id");
        this.entryMetadata.setId(reader.getElementText());
        reader.require(2, "http://www.w3.org/2005/Atom", "id");
    }

    private void readProperties(XMLStreamReader reader, EntityInfoAggregator entitySet, EntityProviderReadProperties readProperties) throws XMLStreamException, EdmException, EntityProviderException {
        reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "properties");
        if (entitySet.getEntityType().hasStream()) {
            this.checkCurrentHandledStartTag("properties");
        } else {
            this.checkCurrentHandledStartTag("content");
        }
        XmlPropertyConsumer xpc = new XmlPropertyConsumer();
        String closeTag = null;
        boolean run = true;
        reader.next();
        while (run) {
            if (reader.isStartElement() && closeTag == null) {
                closeTag = reader.getLocalName();
                if (this.isEdmNamespaceProperty(reader)) {
                    if (this.properties.containsKey(closeTag)) {
                        throw new EntityProviderException(EntityProviderException.DOUBLE_PROPERTY.addContent(new Object[]{closeTag}));
                    }
                    EntityPropertyInfo property = this.getValidatedPropertyInfo(entitySet, closeTag);
                    Object value = xpc.readStartedElement(reader, closeTag, property, this.typeMappings, readProperties);
                    this.properties.put(closeTag, value);
                    closeTag = null;
                }
            } else if (reader.isEndElement()) {
                if (reader.getLocalName().equals(closeTag)) {
                    closeTag = null;
                } else if ("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(reader.getNamespaceURI()) && "properties".equals(reader.getLocalName())) {
                    run = false;
                }
            }
            reader.next();
        }
    }

    private void checkCurrentHandledStartTag(String expectedTagName) throws EntityProviderException {
        if (this.currentHandledStartTagName == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"No current handled start tag name set."}));
        }
        if (!this.currentHandledStartTagName.equals(expectedTagName)) {
            throw new EntityProviderException(EntityProviderException.INVALID_PARENT_TAG.addContent(new Object[]{expectedTagName}).addContent(new Object[]{this.currentHandledStartTagName}));
        }
    }

    private boolean isEdmNamespaceProperty(XMLStreamReader reader) throws EntityProviderException {
        String nsUri = reader.getNamespaceURI();
        if (nsUri == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{reader.getLocalName()}));
        }
        return "http://schemas.microsoft.com/ado/2007/08/dataservices".equals(nsUri);
    }

    private EntityPropertyInfo getValidatedPropertyInfo(EntityInfoAggregator entitySet, String name) throws EntityProviderException {
        EntityPropertyInfo info = entitySet.getPropertyInfo(name);
        if (info == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(new Object[]{name}));
        }
        return info;
    }
}

