/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.VerbSynset;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.ExampleSentences;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseKey;

public class VerbReferenceSynset
extends ReferenceSynset
implements VerbSynset {
    private ExampleSentences examples;

    public VerbReferenceSynset(String definition, String[] examples, SenseKey[] senseKeys, RelationshipPointers pointers, ExampleSentences frames, int lexFile, int offset) {
        super(SynsetType.VERB, definition, examples, senseKeys, pointers, lexFile, offset);
        this.examples = frames;
    }

    public VerbSynset[] getHypernyms() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.HYPERNYM);
    }

    public VerbSynset[] getTroponyms() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.HYPONYM);
    }

    public VerbSynset[] getEntailments() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.ENTAILMENT);
    }

    public VerbSynset[] getOutcomes() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.CAUSE);
    }

    public WordSense[] getPhrases(String wordForm) throws RetrievalException {
        return this.getReferences(RelationshipType.ALSO_SEE, wordForm);
    }

    public VerbSynset[] getVerbGroup() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.VERB_GROUP);
    }

    public String[] getSentenceFrames() {
        return this.examples.getCommonFrames();
    }

    public String[] getSentenceFrames(String wordForm) {
        return this.examples.getFrames(wordForm);
    }

    public String[] getSentenceTemplates(String wordForm) {
        return this.examples.getFormattedTemplates(wordForm);
    }
}

