/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;

public class SynsetTypeConverter {
    public static final char NOUN_CODE = 'n';
    public static final char VERB_CODE = 'v';
    public static final char ADJECTIVE_CODE = 'a';
    public static final char ADVERB_CODE = 'r';
    public static final char ADJECTIVE_SATELLITE_CODE = 's';

    public static SynsetType getType(int typeNumber) {
        SynsetType type = null;
        SynsetType[] types = SynsetType.ALL_TYPES;
        for (int i = 0; i < types.length; ++i) {
            if (typeNumber != types[i].getCode()) continue;
            type = types[i];
        }
        return type;
    }

    public static SynsetType getType(char partOfSpeechCode) {
        SynsetType type = null;
        switch (partOfSpeechCode) {
            case 'n': {
                type = SynsetType.NOUN;
                break;
            }
            case 'v': {
                type = SynsetType.VERB;
                break;
            }
            case 'a': {
                type = SynsetType.ADJECTIVE;
                break;
            }
            case 'r': {
                type = SynsetType.ADVERB;
                break;
            }
            case 's': {
                type = SynsetType.ADJECTIVE_SATELLITE;
                break;
            }
            default: {
                throw new IllegalArgumentException("'" + partOfSpeechCode + "' is an invalid code.");
            }
        }
        return type;
    }
}

