/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.RandomAccessReader;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class SynsetReader
extends RandomAccessReader {
    private static final ResourceBundle FILE_NAMES = ResourceBundle.getBundle(SynsetReader.class.getName());
    private static final Map READER_MAP = new HashMap();

    public static synchronized SynsetReader getInstance(SynsetType type) {
        SynsetReader instance = null;
        WeakReference<SynsetReader> ref = (WeakReference<SynsetReader>)READER_MAP.get(type);
        if (ref != null) {
            instance = (SynsetReader)ref.get();
        }
        if (instance == null) {
            try {
                instance = new SynsetReader(SynsetReader.getFile(type));
                ref = new WeakReference<SynsetReader>(instance);
                READER_MAP.put(type, ref);
            }
            catch (IOException ioe) {
                throw new RetrievalException("Error accessing file: " + ioe.getMessage(), ioe);
            }
        }
        return instance;
    }

    private static File getFile(SynsetType type) {
        String key = Integer.toString(type.getCode());
        String file = FILE_NAMES.getString(key);
        String dir = System.getProperty("wordnet.database.dir", ".");
        return new File(dir, file);
    }

    private SynsetReader(File file) throws IOException {
        super(file);
    }

    public synchronized String readData(SynsetPointer pointer) throws IOException {
        this.seek(pointer.getOffset());
        return this.readToNextEndOfLine();
    }
}

