/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.LeastRecentlyUsedCache;
import edu.smu.tspell.wordnet.impl.file.ParseException;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SynsetParser;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.SynsetReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class SynsetFactory {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static int cacheSize = 500;
    private static SynsetFactory instance;
    private Map pointerSynsets = new WeakHashMap();
    private Map synsetPointers = new WeakHashMap();
    private LeastRecentlyUsedCache cache = new LeastRecentlyUsedCache(cacheSize);

    public static synchronized SynsetFactory getInstance() {
        if (instance == null) {
            instance = new SynsetFactory();
        }
        return instance;
    }

    private SynsetFactory() {
    }

    public synchronized Synset getSynset(SynsetPointer pointer) throws WordNetException {
        Synset synset = this.getCachedSynset(pointer);
        if (synset == null) {
            synset = this.readSynset(pointer);
            this.addToCache(synset, pointer);
            this.cache.put(pointer, synset);
        }
        return synset;
    }

    private Synset getCachedSynset(SynsetPointer pointer) {
        WeakReference weakRef = (WeakReference)this.pointerSynsets.get(pointer);
        return weakRef != null ? (Synset)weakRef.get() : null;
    }

    private void addToCache(Synset synset, SynsetPointer pointer) {
        this.pointerSynsets.put(pointer, new WeakReference<Synset>(synset));
        this.synsetPointers.put(synset, pointer);
    }

    private Synset readSynset(SynsetPointer pointer) throws RetrievalException, ParseException {
        Synset synset;
        String data = null;
        try {
            SynsetReader reader = SynsetReader.getInstance(pointer.getType());
            data = reader.readData(pointer);
            SynsetParser parser = new SynsetParser();
            synset = parser.createSynset(data);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (IOException ioe) {
            throw new RetrievalException("An error occurred reading the synset data", ioe);
        }
        catch (Exception e) {
            throw new ParseException("An error occurred parsing the synset data: " + data, e);
        }
        return synset;
    }

    static {
        String propertyName = "wordnet.cache.synsets";
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                cacheSize = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException nfe) {
                System.err.println("'" + propertyValue + "' is an invalid value for " + propertyName + " and will be ignored.");
            }
        }
    }
}

