/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LeastRecentlyUsedCache {
    private int maximumEntries;
    private Map data;
    private Map keyTimes;
    private TreeMap timeKeys;
    private long lastTime = 0L;

    public LeastRecentlyUsedCache(int maximumEntries) {
        this.maximumEntries = maximumEntries;
        this.data = new HashMap(maximumEntries);
        this.keyTimes = new HashMap(maximumEntries);
        this.timeKeys = new TreeMap();
    }

    public synchronized void put(Object key, Object value) {
        if (this.maximumEntries > 0) {
            Object keyTime = this.keyTimes.get(key);
            if (keyTime == null) {
                if (this.data.size() >= this.maximumEntries) {
                    Object timeKey = this.timeKeys.firstKey();
                    Object dataKey = this.timeKeys.remove(timeKey);
                    this.keyTimes.remove(dataKey);
                    this.data.remove(dataKey);
                }
                this.data.put(key, value);
            } else {
                key = this.timeKeys.remove(keyTime);
            }
            keyTime = this.getUniqueTimeKey();
            this.timeKeys.put(keyTime, key);
            this.keyTimes.put(key, keyTime);
        }
    }

    public synchronized Object get(Object key) {
        Object value = this.data.get(key);
        if (value != null || this.data.containsKey(key)) {
            this.markReferenced(key);
        }
        return value;
    }

    private void markReferenced(Object key) {
        Object keyTime = this.keyTimes.get(key);
        key = this.timeKeys.remove(keyTime);
        Object newTime = this.getUniqueTimeKey();
        this.timeKeys.put(newTime, key);
        this.keyTimes.put(key, newTime);
    }

    private Object getUniqueTimeKey() {
        long time = System.currentTimeMillis();
        if (time <= this.lastTime) {
            time = this.lastTime + 1L;
        }
        this.lastTime = time;
        return new Long(time);
    }
}

