/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SynsetTypeConverter;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class InflectionData {
    private static final String WORD_DELIMITER = " ";
    private static final ResourceBundle TYPE_FILES = ResourceBundle.getBundle(InflectionData.class.getName());
    private static InflectionData instance;
    private Map inflectionMaps = new HashMap();

    public static synchronized InflectionData getInstance() {
        if (instance == null) {
            instance = new InflectionData();
        }
        return instance;
    }

    private InflectionData() throws RetrievalException {
        this.loadExceptions();
    }

    private void loadExceptions() throws RetrievalException {
        Enumeration<String> keys = TYPE_FILES.getKeys();
        while (keys.hasMoreElements()) {
            String keyText = keys.nextElement();
            int typeNumber = Integer.parseInt(keyText);
            String fileName = TYPE_FILES.getString(keyText);
            SynsetType type = SynsetTypeConverter.getType(typeNumber);
            try {
                this.loadExceptions(fileName, type);
            }
            catch (IOException ioe) {
                throw new RetrievalException("Error reading exceptions from file " + fileName + ": " + ioe.getMessage(), ioe);
            }
        }
    }

    private void loadExceptions(String fileName, SynsetType type) throws IOException {
        String dir = System.getProperty("wordnet.database.dir", ".");
        File file = new File(dir, fileName);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, WORD_DELIMITER);
            String inflection = TextTranslator.translateToExternalFormat(tokenizer.nextToken());
            String[] baseForms = new String[tokenizer.countTokens()];
            for (int i = 0; i < baseForms.length; ++i) {
                baseForms[i] = TextTranslator.translateToExternalFormat(tokenizer.nextToken());
            }
            this.putMorphology(inflection, baseForms, type);
            line = reader.readLine();
        }
        reader.close();
    }

    private void putMorphology(String inflection, String[] baseForms, SynsetType type) {
        Map subMap = this.getSubMap(inflection, true);
        subMap.put(type, baseForms);
    }

    public String[] getBaseForms(String wordForm, SynsetType type) {
        String[] baseForms = null;
        Map subMap = this.getSubMap(wordForm, false);
        if (subMap != null) {
            baseForms = (String[])subMap.get(type);
        }
        return baseForms != null ? baseForms : new String[]{};
    }

    private Map getSubMap(String inflection, boolean shouldCreate) {
        String wordForm = inflection.toLowerCase();
        TreeMap subMap = (TreeMap)this.inflectionMaps.get(wordForm);
        if (subMap == null && shouldCreate) {
            subMap = new TreeMap();
            this.inflectionMaps.put(wordForm, subMap);
        }
        return subMap;
    }
}

