/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl;

import edu.smu.tspell.wordnet.impl.RandomAccessReader;
import java.io.File;
import java.io.IOException;

public class LineLocator
extends RandomAccessReader {
    protected LineLocator(File file) throws IOException {
        super(file);
    }

    protected synchronized String getLine(String prefix) throws IOException {
        String match = null;
        long lower = 0L;
        long upper = this.getFileSize();
        long range = upper - lower;
        long seekTarget = this.getFilePointer();
        while (range > 0L) {
            String leftHalf;
            String currentLine;
            String rightHalf;
            long midpoint = lower + range / 2L;
            this.seek(midpoint);
            if (midpoint > 0L) {
                rightHalf = this.readToNextEndOfLine();
                currentLine = this.readToNextEndOfLine();
                if (currentLine.length() == 0) {
                    leftHalf = this.readToPriorEndOfLine(midpoint);
                    currentLine = leftHalf + rightHalf;
                    this.seek(this.getFileSize());
                }
            } else {
                currentLine = this.readToNextEndOfLine();
                rightHalf = "";
            }
            if (currentLine.length() <= 0) break;
            if (currentLine.startsWith(prefix)) {
                match = currentLine;
                seekTarget = this.getFilePointer();
                break;
            }
            int comparison = prefix.compareTo(currentLine);
            if (comparison > 0) {
                lower = this.getFilePointer();
            } else {
                leftHalf = this.readToPriorEndOfLine(midpoint);
                currentLine = leftHalf + rightHalf;
                if (currentLine.startsWith(prefix)) {
                    match = currentLine;
                    seekTarget = this.getFilePointer() + (long)match.length() + 1L;
                    break;
                }
                comparison = prefix.compareTo(currentLine);
                if (comparison >= 0) break;
                upper = this.getFilePointer();
            }
            range = upper - lower;
        }
        if (match != null) {
            this.seek(seekTarget);
        }
        return match;
    }

    protected synchronized String readToPriorEndOfLine(long position) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (position > 0L) {
            this.seek(--position);
            char priorChar = this.readNextCharacter();
            if (priorChar == '\n') break;
            buffer.insert(0, priorChar);
        }
        return buffer.toString();
    }
}

