/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExampleSentences {
    private static final String SYNSET_KEY = "*";
    private Map wordFrames = new HashMap();
    private Map senseTemplates = new HashMap();

    public void addCommonFrame(String frameText) {
        this.addFrame(frameText, SYNSET_KEY);
    }

    public void addFrame(String frameText, String wordForm) {
        ArrayList<String> frameList = (ArrayList<String>)this.wordFrames.get(wordForm);
        if (frameList == null) {
            frameList = new ArrayList<String>();
            this.wordFrames.put(wordForm, frameList);
        }
        frameList.add(frameText);
    }

    public void setTemplates(String wordForm, String[] templates) {
        this.senseTemplates.put(wordForm, templates);
    }

    public String[] getFormattedTemplates(String wordForm) {
        Object[] arguments = new Object[]{wordForm};
        String[] templates = (String[])this.senseTemplates.get(wordForm);
        for (int i = 0; i < templates.length; ++i) {
            templates[i] = MessageFormat.format(templates[i], arguments);
        }
        return templates;
    }

    public String[] getCommonFrames() {
        return this.getFrames(SYNSET_KEY);
    }

    public String[] getFrames(String wordForm) {
        String[] frames = null;
        List frameList = (List)this.wordFrames.get(wordForm);
        if (frameList != null) {
            frames = new String[frameList.size()];
            frameList.toArray(frames);
        }
        return frames != null ? frames : new String[]{};
    }
}

