/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.MessageHandler;
import com.sforce.ws.SessionRenewer;
import com.sforce.ws.transport.JdkHttpTransport;
import com.sforce.ws.util.Verbose;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConnectorConfig {
    private int readTimeout;
    private int connectionTimeout;
    private boolean traceMessage;
    private boolean compression = true;
    private boolean prettyPrintXml;
    private boolean manualLogin;
    private boolean useChunkedPost;
    private String username;
    private String password;
    private String sessionId;
    private String authEndpoint;
    private String serviceEndpoint;
    private String restEndpoint;
    private String traceFile;
    private PrintStream traceStream;
    private String proxyUsername;
    private String proxyPassword;
    private HashMap<String, String> headers;
    private Proxy proxy = null;
    private ArrayList<MessageHandler> handlers = new ArrayList();
    private int maxRequestSize;
    private int maxResponseSize;
    private boolean validateSchema = true;
    private Class transport = JdkHttpTransport.class;
    private SessionRenewer sessionRenewer;
    public static final ConnectorConfig DEFAULT = new ConnectorConfig();

    public Class getTransport() {
        return this.transport;
    }

    public void setTransport(Class transport) {
        this.transport = transport;
    }

    public void setNtlmDomain(String domain) {
        if (System.getProperty("http.auth.ntlm.domain") == null) {
            System.setProperty("http.auth.ntlm.domain", domain);
        } else {
            Verbose.log("http.auth.ntlm.domain already set");
        }
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public void setProxy(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        this.proxy = new Proxy(Proxy.Type.HTTP, addr);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy == null ? Proxy.NO_PROXY : this.proxy;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestHeader(String key) {
        String ret = null;
        if (this.headers != null) {
            ret = this.headers.get(key);
        }
        return ret;
    }

    public void setRequestHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(key, value);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isPrettyPrintXml() {
        return this.prettyPrintXml;
    }

    public void setPrettyPrintXml(boolean prettyPrintXml) {
        this.prettyPrintXml = prettyPrintXml;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        if (serviceEndpoint == null || serviceEndpoint.equals("")) {
            throw new IllegalArgumentException("illegal service endpoint " + serviceEndpoint);
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compress) {
        this.compression = compress;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isTraceMessage() {
        return this.traceMessage;
    }

    public void setTraceMessage(boolean traceMessage) {
        this.traceMessage = traceMessage;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public void setTraceFile(String traceFile) throws FileNotFoundException {
        this.traceFile = traceFile;
        File file = new File(traceFile);
        if (file.exists()) {
            Verbose.log("Log file already exists, appending to " + file);
        }
        this.traceStream = new PrintStream(new FileOutputStream(file, true), true);
    }

    public PrintStream getTraceStream() {
        return this.traceStream == null ? System.out : this.traceStream;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public void setAuthEndpoint(String authEndpoint) {
        if (authEndpoint == null || authEndpoint.equals("")) {
            throw new IllegalArgumentException("Illegal auth endpoint " + authEndpoint);
        }
        this.authEndpoint = authEndpoint;
    }

    public void setManualLogin(boolean manualLogin) {
        this.manualLogin = manualLogin;
    }

    public boolean isManualLogin() {
        return this.manualLogin;
    }

    public void setUseChunkedPost(boolean chunk) {
        this.useChunkedPost = chunk;
    }

    public boolean useChunkedPost() {
        return this.useChunkedPost;
    }

    public void verifyPartnerEndpoint() throws ConnectionException {
        this.verifyEndpoint("/services/Soap/u/");
    }

    public void verifyEnterpriseEndpoint() throws ConnectionException {
        this.verifyEndpoint("/services/Soap/c/");
    }

    public Iterator<MessageHandler> getMessagerHandlers() {
        return this.handlers.iterator();
    }

    public boolean hasMessageHandlers() {
        return this.handlers.size() != 0;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.handlers.add(handler);
    }

    public void clearMessageHandlers() {
        this.handlers.clear();
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    private void verifyEndpoint(String contains) throws ConnectionException {
        if (this.authEndpoint != null && !this.authEndpoint.contains(contains)) {
            throw new ConnectionException("Check authEndpoint. It must contain '" + contains + "'. " + "authEndpoint specified " + this.authEndpoint);
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.contains(contains)) {
            throw new ConnectionException("Check serviceEndpoint. It must contain '" + contains + "'. " + "serviceEndpoint specified " + this.serviceEndpoint);
        }
    }

    public String getRestEndpoint() {
        return this.restEndpoint;
    }

    public void setRestEndpoint(String restEndpoint) {
        this.restEndpoint = restEndpoint;
    }

    public SessionRenewer getSessionRenewer() {
        return this.sessionRenewer;
    }

    public void setSessionRenewer(SessionRenewer sessionRenewer) {
        this.sessionRenewer = sessionRenewer;
    }
}

