/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import com.codahale.metrics.Gauge;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DataImporter importer;
    private boolean debugEnabled = true;
    private String myName = "dataimport";
    private MetricsMap metrics;
    private static final String PARAM_WRITER_IMPL = "writerImpl";
    private static final String DEFAULT_WRITER_NAME = "SolrWriter";
    public static final String ENABLE_DEBUG = "enableDebug";

    public DataImporter getImporter() {
        return this.importer;
    }

    public void init(NamedList args) {
        super.init(args);
        HashMap<String, String> macro = new HashMap<String, String>();
        macro.put("expandMacros", "false");
        this.defaults = SolrParams.wrapDefaults((SolrParams)this.defaults, (SolrParams)new MapSolrParams(macro));
    }

    public void inform(SolrCore core) {
        try {
            String name = this.getPluginInfo().name;
            if (name.startsWith("/")) {
                this.myName = name.substring(1);
            }
            this.myName = this.myName.replaceAll("/", "_");
            this.debugEnabled = StrUtils.parseBool((String)((String)this.initArgs.get(ENABLE_DEBUG)), (boolean)true);
            this.importer = new DataImporter(core, this.myName);
        }
        catch (Exception e) {
            log.error("Exception while loading DataImporter", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while loading DataImporter", (Throwable)e);
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Iterator iterator;
        rsp.setHttpCaching(false);
        ContentStream contentStream = null;
        Iterable streams = req.getContentStreams();
        if (streams != null && (iterator = streams.iterator()).hasNext()) {
            ContentStream stream;
            contentStream = stream = (ContentStream)iterator.next();
        }
        SolrParams params = req.getParams();
        NamedList defaultParams = (NamedList)this.initArgs.get("defaults");
        RequestInfo requestParams = new RequestInfo(req, this.getParamsMap(params), contentStream);
        String command = requestParams.getCommand();
        if ("show-config".equals(command)) {
            String dataConfigFile = params.get("config");
            String dataConfig = params.get("dataConfig");
            if (dataConfigFile != null) {
                dataConfig = SolrWriter.getResourceAsString(req.getCore().getResourceLoader().openResource(dataConfigFile));
            }
            if (dataConfig == null) {
                rsp.add("status", (Object)"Configuration not found");
            } else {
                ModifiableSolrParams rawParams = new ModifiableSolrParams(req.getParams());
                rawParams.set("wt", new String[]{"raw"});
                req.setParams((SolrParams)rawParams);
                ContentStreamBase.StringStream content = new ContentStreamBase.StringStream(dataConfig);
                rsp.add("content", (Object)content);
            }
            return;
        }
        rsp.add("initArgs", (Object)this.initArgs);
        String message = "";
        if (command != null) {
            rsp.add("command", (Object)command);
        }
        if (this.importer == null) {
            rsp.add("status", (Object)"DataImportHandler started. Not Initialized. No commands can be run");
            return;
        }
        if (command != null && "abort".equals(command)) {
            this.importer.runCmd(requestParams, null);
        } else if (this.importer.isBusy()) {
            message = "A command is still running...";
        } else if (command != null) {
            if ("full-import".equals(command) || "delta-import".equals(command) || "import".equals(command)) {
                this.importer.maybeReloadConfiguration(requestParams, defaultParams);
                UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessorChain(params);
                UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
                SolrResourceLoader loader = req.getCore().getResourceLoader();
                DIHWriter sw = this.getSolrWriter(processor, loader, requestParams, req);
                if (requestParams.isDebug()) {
                    if (this.debugEnabled) {
                        this.importer.runCmd(requestParams, sw);
                        rsp.add("mode", (Object)"debug");
                        rsp.add("documents", requestParams.getDebugInfo().debugDocuments);
                        if (requestParams.getDebugInfo().debugVerboseOutput != null) {
                            rsp.add("verbose-output", requestParams.getDebugInfo().debugVerboseOutput);
                        }
                    } else {
                        message = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
                    }
                } else if (requestParams.getContentStream() == null && !requestParams.isSyncMode()) {
                    this.importer.runAsync(requestParams, sw);
                } else {
                    this.importer.runCmd(requestParams, sw);
                }
            } else if ("reload-config".equals(command)) {
                message = this.importer.maybeReloadConfiguration(requestParams, defaultParams) ? "Configuration Re-loaded sucessfully" : "Configuration NOT Re-loaded...Data Importer is busy.";
            }
        }
        rsp.add("status", (Object)(this.importer.isBusy() ? "busy" : "idle"));
        rsp.add("importResponse", (Object)message);
        rsp.add("statusMessages", this.importer.getStatusMessages());
    }

    private Map<String, Object> getParamsMap(SolrParams params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry pair : params) {
            String s = (String)pair.getKey();
            String[] val = (String[])pair.getValue();
            if (val == null || val.length < 1) continue;
            if (val.length == 1) {
                result.put(s, val[0]);
                continue;
            }
            result.put(s, Arrays.asList(val));
        }
        return result;
    }

    private DIHWriter getSolrWriter(UpdateRequestProcessor processor, SolrResourceLoader loader, RequestInfo requestParams, SolrQueryRequest req) {
        SolrParams reqParams = req.getParams();
        String writerClassStr = null;
        if (reqParams != null && reqParams.get(PARAM_WRITER_IMPL) != null) {
            writerClassStr = reqParams.get(PARAM_WRITER_IMPL);
        }
        if (writerClassStr != null && !writerClassStr.equals(DEFAULT_WRITER_NAME) && !writerClassStr.equals(DocBuilder.class.getPackage().getName() + "." + DEFAULT_WRITER_NAME)) {
            try {
                Class writerClass = DocBuilder.loadClass(writerClassStr, req.getCore());
                Constructor cnstr = writerClass.getConstructor(UpdateRequestProcessor.class, SolrQueryRequest.class);
                return (DIHWriter)cnstr.newInstance(processor, req);
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Unable to load Writer implementation:" + writerClassStr, e);
            }
        }
        return new SolrWriter(processor, req){

            @Override
            public boolean upload(SolrInputDocument document) {
                try {
                    return super.upload(document);
                }
                catch (RuntimeException e) {
                    log.error("Exception while adding: " + document, (Throwable)e);
                    return false;
                }
            }
        };
    }

    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        super.initializeMetrics(manager, registryName, tag, scope);
        this.metrics = new MetricsMap((detailed, map) -> {
            if (this.importer != null) {
                DocBuilder.Statistics cumulative = this.importer.cumulativeStatistics;
                map.put("Status", this.importer.getStatus().toString());
                if (this.importer.docBuilder != null) {
                    DocBuilder.Statistics running = this.importer.docBuilder.importStatistics;
                    map.put("Documents Processed", running.docCount);
                    map.put("Requests made to DataSource", running.queryCount);
                    map.put("Rows Fetched", running.rowsCount);
                    map.put("Documents Deleted", running.deletedDocCount);
                    map.put("Documents Skipped", running.skipDocCount);
                }
                map.put("Total Documents Processed", cumulative.docCount);
                map.put("Total Requests made to DataSource", cumulative.queryCount);
                map.put("Total Rows Fetched", cumulative.rowsCount);
                map.put("Total Documents Deleted", cumulative.deletedDocCount);
                map.put("Total Documents Skipped", cumulative.skipDocCount);
            }
        });
        manager.registerGauge((SolrInfoBean)this, registryName, (Gauge)this.metrics, tag, true, "importer", new String[]{this.getCategory().toString(), scope});
    }

    public String getDescription() {
        return "Manage data import from databases to Solr";
    }
}

