/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Music;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MusicJSONImpl
extends CategoryJSONImpl
implements Music,
Serializable {
    private static final long serialVersionUID = -4989145210934063277L;

    MusicJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    MusicJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Music> createMusicList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Music> musics = new ResponseListImpl<Music>(size, json, new Music[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject musicJSONObject = list.getJSONObject(i);
                MusicJSONImpl music = new MusicJSONImpl(musicJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(music, musicJSONObject);
                }
                musics.add(music);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(musics, list);
            }
            return musics;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }
}

