/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.conf;

import facebook4j.conf.Configuration;
import facebook4j.conf.ConfigurationBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class PropertyConfiguration
extends ConfigurationBase
implements Serializable {
    private static final long serialVersionUID = -6424033561218975631L;
    public static final String DEBUG = "debug";
    public static final String HTTP_USER_AGENT = "http.userAgent";
    public static final String HTTP_USE_SSL = "http.useSSL";
    public static final String HTTP_PRETTY_DEBUG = "http.prettyDebug";
    public static final String HTTP_GZIP = "http.gzip";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    public static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    public static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    public static final String HTTP_RETRY_COUNT = "http.retryCount";
    public static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    public static final String HTTP_MAX_TOTAL_CONNECTIONS = "http.maxTotalConnections";
    public static final String HTTP_DEFAULT_MAX_PER_ROUTE = "http.defaultMaxPerRoute";
    public static final String OAUTH_APP_ID = "oauth.appId";
    public static final String OAUTH_APP_SECRET = "oauth.appSecret";
    public static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    public static final String OAUTH_PERMISSIONS = "oauth.permissions";
    public static final String OAUTH_CALLBACK_URL = "oauth.callbackURL";
    public static final String SECURITY_APP_SECRET_PROOF_ENABLED = "security.appSecretProofEnabled";
    public static final String SECURITY_APP_SECRET_PROOF_CACHE_SIZE = "security.appSecretProofCacheSize";
    public static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    public static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    public static final String OAUTH_ACCESS_TOKEN_INFO_URL = "oauth.accessTokenInfoURL";
    public static final String OAUTH_DEVICE_TOKEN_URL = "oauth.deviceTokenURL";
    public static final String REST_BASE_URL = "restBaseURL";
    public static final String VIDEO_BASE_URL = "videoBaseURL";
    public static final String JSON_STORE_ENABLED = "jsonStoreEnabled";
    public static final String MBEAN_ENABLED = "mbeanEnabled";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String CLIENT_URL = "clientURL";

    public PropertyConfiguration(InputStream is) {
        Properties props = new Properties();
        this.loadProperties(props, is);
        this.setFieldsWithTreePath(props, "/");
    }

    public PropertyConfiguration(Properties props) {
        this(props, "/");
    }

    public PropertyConfiguration(Properties props, String treePath) {
        this.setFieldsWithTreePath(props, treePath);
    }

    PropertyConfiguration(String treePath) {
        Properties props;
        try {
            props = (Properties)System.getProperties().clone();
            try {
                Map<String, String> envMap = System.getenv();
                for (String key : envMap.keySet()) {
                    props.setProperty(key, envMap.get(key));
                }
            }
            catch (SecurityException envMap) {
                // empty catch block
            }
            this.normalize(props);
        }
        catch (SecurityException ignore) {
            props = new Properties();
        }
        String FACEBOOK4J_PROPERTIES = "facebook4j.properties";
        this.loadProperties(props, "." + File.separatorChar + "facebook4j.properties");
        this.loadProperties(props, Configuration.class.getResourceAsStream("/facebook4j.properties"));
        this.loadProperties(props, Configuration.class.getResourceAsStream("/WEB-INF/facebook4j.properties"));
        try {
            this.loadProperties(props, new FileInputStream("WEB-INF/facebook4j.properties"));
        }
        catch (SecurityException securityException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.setFieldsWithTreePath(props, treePath);
    }

    PropertyConfiguration() {
        this("/");
    }

    private boolean notNull(Properties props, String prefix, String name) {
        return props.getProperty(prefix + name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties(Properties props, String path) {
        FileInputStream fis = null;
        try {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                fis = new FileInputStream(file);
                props.load(fis);
                this.normalize(props);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean loadProperties(Properties props, InputStream is) {
        try {
            props.load(is);
            this.normalize(props);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void normalize(Properties props) {
        Set<Object> keys = props.keySet();
        ArrayList<String> toBeNormalized = new ArrayList<String>(10);
        for (Object key : keys) {
            String keyStr = (String)key;
            if (-1 == keyStr.indexOf("facebook4j.")) continue;
            toBeNormalized.add(keyStr);
        }
        for (String keyStr : toBeNormalized) {
            String property = props.getProperty(keyStr);
            int index = keyStr.indexOf("facebook4j.");
            String newKey = keyStr.substring(0, index) + keyStr.substring(index + 11);
            props.setProperty(newKey, property);
        }
    }

    private void setFieldsWithTreePath(Properties props, String treePath) {
        this.setFieldsWithPrefix(props, "");
        String[] splitArray = treePath.split("/");
        String prefix = null;
        for (String split : splitArray) {
            if ("".equals(split)) continue;
            prefix = null == prefix ? split + "." : prefix + split + ".";
            this.setFieldsWithPrefix(props, prefix);
        }
    }

    private void setFieldsWithPrefix(Properties props, String prefix) {
        if (this.notNull(props, prefix, DEBUG)) {
            this.setDebug(this.getBoolean(props, prefix, DEBUG));
        }
        if (this.notNull(props, prefix, HTTP_USE_SSL)) {
            this.setUseSSL(this.getBoolean(props, prefix, HTTP_USE_SSL));
        }
        if (this.notNull(props, prefix, HTTP_PRETTY_DEBUG)) {
            this.setPrettyDebugEnabled(this.getBoolean(props, prefix, HTTP_PRETTY_DEBUG));
        }
        if (this.notNull(props, prefix, HTTP_GZIP)) {
            this.setGZIPEnabled(this.getBoolean(props, prefix, HTTP_GZIP));
        }
        if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        } else if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_USER)) {
            this.setHttpProxyUser(this.getString(props, prefix, HTTP_PROXY_USER));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_PASSWORD)) {
            this.setHttpProxyPassword(this.getString(props, prefix, HTTP_PROXY_PASSWORD));
        }
        if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        } else if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        }
        if (this.notNull(props, prefix, HTTP_CONNECTION_TIMEOUT)) {
            this.setHttpConnectionTimeout(this.getIntProperty(props, prefix, HTTP_CONNECTION_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_READ_TIMEOUT)) {
            this.setHttpReadTimeout(this.getIntProperty(props, prefix, HTTP_READ_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_COUNT)) {
            this.setHttpRetryCount(this.getIntProperty(props, prefix, HTTP_RETRY_COUNT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_INTERVAL_SECS)) {
            this.setHttpRetryIntervalSeconds(this.getIntProperty(props, prefix, HTTP_RETRY_INTERVAL_SECS));
        }
        if (this.notNull(props, prefix, HTTP_MAX_TOTAL_CONNECTIONS)) {
            this.setHttpMaxTotalConnections(this.getIntProperty(props, prefix, HTTP_MAX_TOTAL_CONNECTIONS));
        }
        if (this.notNull(props, prefix, HTTP_DEFAULT_MAX_PER_ROUTE)) {
            this.setHttpDefaultMaxPerRoute(this.getIntProperty(props, prefix, HTTP_DEFAULT_MAX_PER_ROUTE));
        }
        if (this.notNull(props, prefix, OAUTH_APP_ID)) {
            this.setOAuthAppId(this.getString(props, prefix, OAUTH_APP_ID));
        }
        if (this.notNull(props, prefix, OAUTH_APP_SECRET)) {
            this.setOAuthAppSecret(this.getString(props, prefix, OAUTH_APP_SECRET));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN)) {
            this.setOAuthAccessToken(this.getString(props, prefix, OAUTH_ACCESS_TOKEN));
        }
        if (this.notNull(props, prefix, OAUTH_PERMISSIONS)) {
            this.setOAuthPermissions(this.getString(props, prefix, OAUTH_PERMISSIONS));
        }
        if (this.notNull(props, prefix, OAUTH_CALLBACK_URL)) {
            this.setOAuthCallbackURL(this.getString(props, prefix, OAUTH_CALLBACK_URL));
        }
        if (this.notNull(props, prefix, SECURITY_APP_SECRET_PROOF_ENABLED)) {
            this.setAppSecretProofEnabled(this.getBoolean(props, prefix, SECURITY_APP_SECRET_PROOF_ENABLED));
        }
        if (this.notNull(props, prefix, SECURITY_APP_SECRET_PROOF_CACHE_SIZE)) {
            this.setAppSecretProofCacheSize(this.getIntProperty(props, prefix, SECURITY_APP_SECRET_PROOF_CACHE_SIZE));
        }
        if (this.notNull(props, prefix, CLIENT_VERSION)) {
            this.setClientVersion(this.getString(props, prefix, CLIENT_VERSION));
        }
        if (this.notNull(props, prefix, CLIENT_URL)) {
            this.setClientURL(this.getString(props, prefix, CLIENT_URL));
        }
        if (this.notNull(props, prefix, HTTP_USER_AGENT)) {
            this.setUserAgent(this.getString(props, prefix, HTTP_USER_AGENT));
        }
        if (this.notNull(props, prefix, OAUTH_AUTHORIZATION_URL)) {
            this.setOAuthAuthorizationURL(this.getString(props, prefix, OAUTH_AUTHORIZATION_URL));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_URL)) {
            this.setOAuthAccessTokenURL(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_INFO_URL)) {
            this.setOAuthAccessTokenInfoURL(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_INFO_URL));
        }
        if (this.notNull(props, prefix, OAUTH_DEVICE_TOKEN_URL)) {
            this.setOAuthDeviceTokenURL(this.getString(props, prefix, OAUTH_DEVICE_TOKEN_URL));
        }
        if (this.notNull(props, prefix, REST_BASE_URL)) {
            this.setRestBaseURL(this.getString(props, prefix, REST_BASE_URL));
        }
        if (this.notNull(props, prefix, VIDEO_BASE_URL)) {
            this.setVideoBaseURL(this.getString(props, prefix, VIDEO_BASE_URL));
        }
        if (this.notNull(props, prefix, JSON_STORE_ENABLED)) {
            this.setJSONStoreEnabled(this.getBoolean(props, prefix, JSON_STORE_ENABLED));
        }
        if (this.notNull(props, prefix, MBEAN_ENABLED)) {
            this.setMBeanEnabled(this.getBoolean(props, prefix, MBEAN_ENABLED));
        }
        this.cacheInstance();
    }

    protected boolean getBoolean(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        return Boolean.valueOf(value);
    }

    protected int getIntProperty(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected String getString(Properties props, String prefix, String name) {
        return props.getProperty(prefix + name);
    }

    protected Object readResolve() throws ObjectStreamException {
        return super.readResolve();
    }
}

