/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.PrivacyParameter;
import facebook4j.PrivacyType;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrivacyBuilder {
    private PrivacyParameter privacyParameter = new PrivacyParameter();

    public PrivacyBuilder setValue(PrivacyType value) {
        this.checkNotBuilt();
        this.privacyParameter.setValue(value.toString());
        return this;
    }

    public PrivacyBuilder setFriends(PrivacyType friends) {
        this.checkNotBuilt();
        this.privacyParameter.setFriends(friends.toString());
        return this;
    }

    public PrivacyBuilder setNetworks(String networks) {
        this.checkNotBuilt();
        this.privacyParameter.setNetworks(networks);
        return this;
    }

    public PrivacyBuilder setNetworks(List<String> networks) {
        this.checkNotBuilt();
        this.privacyParameter.setNetworks(z_F4JInternalStringUtil.join(networks.toArray(new String[networks.size()])));
        return this;
    }

    public PrivacyBuilder addNetwork(String network) {
        this.checkNotBuilt();
        String networks = this.privacyParameter.getNetworks();
        if (networks == null) {
            this.privacyParameter.setNetworks(network);
        } else {
            this.privacyParameter.setNetworks(networks + "," + network);
        }
        return this;
    }

    public PrivacyBuilder setAllow(String allow) {
        this.checkNotBuilt();
        this.privacyParameter.setAllow(allow);
        return this;
    }

    public PrivacyBuilder setAllow(List<String> allow) {
        this.checkNotBuilt();
        this.privacyParameter.setAllow(z_F4JInternalStringUtil.join(allow.toArray(new String[allow.size()])));
        return this;
    }

    public PrivacyBuilder addAllow(String allow) {
        this.checkNotBuilt();
        String allows = this.privacyParameter.getAllow();
        if (allows == null) {
            this.privacyParameter.setAllow(allow);
        } else {
            this.privacyParameter.setAllow(allows + "," + allow);
        }
        return this;
    }

    public PrivacyBuilder setDeny(String deny) {
        this.checkNotBuilt();
        this.privacyParameter.setDeny(deny);
        return this;
    }

    public PrivacyBuilder setDeny(List<String> deny) {
        this.checkNotBuilt();
        this.privacyParameter.setDeny(z_F4JInternalStringUtil.join(deny.toArray(new String[deny.size()])));
        return this;
    }

    public PrivacyBuilder addDeny(String deny) {
        this.checkNotBuilt();
        String denys = this.privacyParameter.getDeny();
        if (denys == null) {
            this.privacyParameter.setDeny(deny);
        } else {
            this.privacyParameter.setDeny(denys + "," + deny);
        }
        return this;
    }

    public PrivacyParameter build() {
        this.checkNotBuilt();
        try {
            PrivacyParameter privacyParameter = this.privacyParameter;
            return privacyParameter;
        }
        finally {
            this.privacyParameter = null;
        }
    }

    private void checkNotBuilt() {
        if (this.privacyParameter == null) {
            throw new IllegalStateException("Cannot use this builder any longer, build() has already been called");
        }
    }
}

