/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Post;
import facebook4j.PrivacyParameter;
import facebook4j.TargetingParameter;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.org.json.JSONArray;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostUpdate
implements Serializable {
    private static final long serialVersionUID = 7540889634334208530L;
    private String message;
    private URL link;
    private URL picture;
    private String name;
    private String caption;
    private String description;
    private List<PostAction> actions;
    private String place;
    private String tags;
    private PrivacyParameter privacy;
    private String objectAttachment;
    private TargetingParameter targeting;
    private Boolean published;
    private Integer scheduledPublishTime;

    public PostUpdate(String message) {
        this.message = message;
    }

    public PostUpdate(URL link) {
        this.link = link;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public PostUpdate message(String message) {
        this.setMessage(message);
        return this;
    }

    public URL getLink() {
        return this.link;
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public PostUpdate link(URL link) {
        this.setLink(link);
        return this;
    }

    public URL getPicture() {
        return this.picture;
    }

    public void setPicture(URL picture) {
        this.picture = picture;
    }

    public PostUpdate picture(URL picture) {
        this.setPicture(picture);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PostUpdate name(String name) {
        this.setName(name);
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public PostUpdate caption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostUpdate description(String description) {
        this.setDescription(description);
        return this;
    }

    public List<PostAction> getActions() {
        return this.actions;
    }

    public void setActions(List<PostAction> actions) {
        this.actions = actions;
    }

    public PostUpdate actions(List<PostAction> actions) {
        this.setActions(actions);
        return this;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public PostUpdate place(String place) {
        this.setPlace(place);
        return this;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public PostUpdate tags(String tags) {
        this.setTags(tags);
        return this;
    }

    public PrivacyParameter getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(PrivacyParameter privacy) {
        this.privacy = privacy;
    }

    public PostUpdate privacy(PrivacyParameter privacy) {
        this.setPrivacy(privacy);
        return this;
    }

    public String getObjectAttachment() {
        return this.objectAttachment;
    }

    public void setObjectAttachment(String objectAttachment) {
        this.objectAttachment = objectAttachment;
    }

    public PostUpdate objectAttachment(String objectAttachment) {
        this.setObjectAttachment(objectAttachment);
        return this;
    }

    public TargetingParameter getTargeting() {
        return this.targeting;
    }

    public void setTargeting(TargetingParameter targeting) {
        this.targeting = targeting;
    }

    public PostUpdate targeting(TargetingParameter targetingParameter) {
        this.setTargeting(targetingParameter);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public PostUpdate published(Boolean published) {
        this.setPublished(published);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public void setScheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(time).intValue());
    }

    public PostUpdate scheduledPublishTime(Integer scheduledPublishTime) {
        this.setScheduledPublishTime(scheduledPublishTime);
        return this;
    }

    public PostUpdate scheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(time).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (this.message != null) {
            params.add(new HttpParameter("message", this.message));
        }
        if (this.link != null) {
            params.add(new HttpParameter("link", this.link.toString()));
        }
        if (this.picture != null) {
            params.add(new HttpParameter("picture", this.picture.toString()));
        }
        if (this.name != null) {
            params.add(new HttpParameter("name", this.name));
        }
        if (this.caption != null) {
            params.add(new HttpParameter("caption", this.caption));
        }
        if (this.description != null) {
            params.add(new HttpParameter("description", this.description));
        }
        if (this.actions != null && this.actions.size() != 0) {
            JSONArray jsonArray = new JSONArray(this.actions);
            params.add(new HttpParameter("actions", jsonArray.toString()));
        }
        if (this.place != null) {
            params.add(new HttpParameter("place", this.place));
        }
        if (this.tags != null) {
            params.add(new HttpParameter("tags", this.tags));
        }
        if (this.privacy != null) {
            params.add(new HttpParameter("privacy", this.privacy.asJSONString()));
        }
        if (this.objectAttachment != null) {
            params.add(new HttpParameter("object_attachment", this.objectAttachment));
        }
        if (this.targeting != null) {
            params.add(new HttpParameter("targeting", this.targeting.asJSONString()));
        }
        if (this.published != null) {
            params.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            params.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostUpdate)) {
            return false;
        }
        PostUpdate that = (PostUpdate)o;
        if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.caption != null ? !this.caption.equals(that.caption) : that.caption != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.link != null ? !this.link.equals(that.link) : that.link != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.objectAttachment != null ? !this.objectAttachment.equals(that.objectAttachment) : that.objectAttachment != null) {
            return false;
        }
        if (this.picture != null ? !this.picture.equals(that.picture) : that.picture != null) {
            return false;
        }
        if (this.place != null ? !this.place.equals(that.place) : that.place != null) {
            return false;
        }
        if (this.privacy != null ? !this.privacy.equals(that.privacy) : that.privacy != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.targeting != null ? !this.targeting.equals(that.targeting) : that.targeting != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(that.published) : that.published != null) {
            return false;
        }
        return !(this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(that.scheduledPublishTime) : that.scheduledPublishTime != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
        result = 31 * result + (this.picture != null ? this.picture.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.caption != null ? this.caption.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        result = 31 * result + (this.place != null ? this.place.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.privacy != null ? this.privacy.hashCode() : 0);
        result = 31 * result + (this.objectAttachment != null ? this.objectAttachment.hashCode() : 0);
        result = 31 * result + (this.targeting != null ? this.targeting.hashCode() : 0);
        result = 31 * result + (this.published != null ? this.published.hashCode() : 0);
        result = 31 * result + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PostUpdate{message='" + this.message + '\'' + ", link=" + this.link + ", picture=" + this.picture + ", name='" + this.name + '\'' + ", caption='" + this.caption + '\'' + ", description='" + this.description + '\'' + ", actions=" + this.actions + ", place='" + this.place + '\'' + ", tags='" + this.tags + '\'' + ", privacy=" + this.privacy + ", objectAttachment='" + this.objectAttachment + '\'' + ", targeting=" + this.targeting + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }

    public static class PostAction
    implements Post.Action,
    Serializable {
        private static final long serialVersionUID = 2016068387645669580L;
        private String name;
        private String link;

        public PostAction(String name, String link) {
            this.name = name;
            this.link = link;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }
    }
}

