/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Version;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.IOException;
import java.util.List;

public class FacebookException
extends Exception {
    private static final long serialVersionUID = 1200504652249544235L;
    private int statusCode = -1;
    private HttpResponse response;
    private String errorType;
    private String errorMessage;
    private int errorCode = -1;
    private int errorSubcode = -1;

    public FacebookException(String message, Throwable cause) {
        super(message, cause);
        this.decode(message);
    }

    public FacebookException(String message, HttpResponse res) {
        this(message);
        this.response = res;
        this.statusCode = res.getStatusCode();
    }

    public FacebookException(String message) {
        this(message, (Throwable)null);
    }

    public FacebookException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public FacebookException(String message, Throwable cause, int statusCode) {
        this(message, cause);
        this.statusCode = statusCode;
    }

    public String getMessage() {
        StringBuilder value = new StringBuilder();
        if (this.errorMessage != null && this.errorCode != -1) {
            value.append("message - ").append(this.errorMessage).append("\n");
            value.append("code - ").append(this.errorCode).append("\n");
            if (this.errorSubcode != -1) {
                value.append("subcode - ").append(this.errorSubcode).append("\n");
            }
            value.append("Relevant information for error recovery can be found on the Facebook Developers Document:\n").append("\thttps://developers.facebook.com/docs/graph-api/using-graph-api/#errors\n");
        } else {
            value.append(super.getMessage());
        }
        return value.toString();
    }

    private void decode(String str) {
        if (str != null && str.startsWith("{")) {
            try {
                JSONObject json = new JSONObject(str);
                if (!json.isNull("error")) {
                    JSONObject error = json.getJSONObject("error");
                    this.errorType = error.getString("type");
                    this.errorMessage = error.getString("message");
                    this.errorCode = error.getInt("code");
                    this.errorSubcode = error.getInt("error_subcode");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorSubcode() {
        return this.errorSubcode;
    }

    public String getResponseHeader(String name) {
        List<String> header;
        String value = null;
        if (this.response != null && (header = this.response.getResponseHeaderFields().get(name)).size() > 0) {
            value = header.get(0);
        }
        return value;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FacebookException)) {
            return false;
        }
        FacebookException that = (FacebookException)o;
        if (this.errorCode != that.errorCode) {
            return false;
        }
        if (this.errorSubcode != that.errorSubcode) {
            return false;
        }
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(that.errorMessage) : that.errorMessage != null) {
            return false;
        }
        if (this.errorType != null ? !this.errorType.equals(that.errorType) : that.errorType != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.errorType != null ? this.errorType.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + this.errorCode;
        result = 31 * result + this.errorSubcode;
        return result;
    }

    public String toString() {
        return this.getMessage() + "\nFacebookException{statusCode=" + this.statusCode + ", errorType='" + this.errorType + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", errorCode=" + this.errorCode + ", errorSubcode=" + this.errorSubcode + ", version=" + Version.getVersion() + '}';
    }
}

