/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EXTERNALBindRequest
extends SASLBindRequest {
    public static final String EXTERNAL_MECHANISM_NAME = "EXTERNAL";
    private static final long serialVersionUID = 7520760039662616663L;
    private int messageID = -1;
    private final String authzID;

    public EXTERNALBindRequest() {
        this((String)null, StaticUtils.NO_CONTROLS);
    }

    public EXTERNALBindRequest(String authzID) {
        this(authzID, StaticUtils.NO_CONTROLS);
    }

    public EXTERNALBindRequest(Control ... controls) {
        this((String)null, controls);
    }

    public EXTERNALBindRequest(String authzID, Control ... controls) {
        super(controls);
        this.authzID = authzID;
    }

    public String getAuthorizationID() {
        return this.authzID;
    }

    @Override
    public String getSASLMechanismName() {
        return EXTERNAL_MECHANISM_NAME;
    }

    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = connection.nextMessageID();
        ASN1OctetString creds = this.authzID == null ? null : new ASN1OctetString(this.authzID);
        return this.sendBindRequest(connection, "", creds, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    @Override
    public EXTERNALBindRequest getRebindRequest(String host, int port) {
        return new EXTERNALBindRequest(this.authzID, this.getControls());
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public EXTERNALBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public EXTERNALBindRequest duplicate(Control[] controls) {
        EXTERNALBindRequest bindRequest = new EXTERNALBindRequest(this.authzID, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("EXTERNALBindRequest(");
        boolean added = false;
        if (this.authzID != null) {
            buffer.append("authzID='");
            buffer.append(this.authzID);
            buffer.append('\'');
            added = true;
        }
        if ((controls = this.getControls()).length > 0) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        Control[] controls;
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(2);
        if (this.authzID != null) {
            constructorArgs.add(ToCodeArgHelper.createString(this.authzID, "Authorization ID"));
        }
        if ((controls = this.getControls()).length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "EXTERNALBindRequest", requestID + "Request", "new EXTERNALBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

