/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalAsyncLoadingCache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.LocalLoadingCache;
import com.github.benmanes.caffeine.cache.LocalManualCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.RemovalNotification;
import com.github.benmanes.caffeine.cache.SerializationProxy;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.github.benmanes.caffeine.cache.tracing.Tracer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

final class UnboundedLocalCache<K, V>
implements LocalCache<K, V> {
    @Nullable
    final RemovalListener<K, V> removalListener;
    final ConcurrentHashMap<K, V> data;
    final Executor executor;
    final Ticker ticker;
    final long id;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    boolean isRecordingStats;
    StatsCounter statsCounter;

    UnboundedLocalCache(Caffeine<? super K, ? super V> builder, boolean async) {
        this.data = new ConcurrentHashMap(builder.getInitialCapacity());
        this.statsCounter = builder.getStatsCounterSupplier().get();
        this.removalListener = builder.getRemovalListener(async);
        this.isRecordingStats = builder.isRecordingStats();
        this.id = this.tracer().register(builder.name());
        this.executor = builder.getExecutor();
        this.ticker = builder.getTicker();
    }

    @Override
    public V getIfPresent(Object key, boolean recordStats) {
        V value = this.data.get(key);
        this.tracer().recordRead(this.id, key);
        if (recordStats) {
            if (value == null) {
                this.statsCounter.recordMisses(1);
            } else {
                this.statsCounter.recordHits(1);
            }
        }
        return value;
    }

    @Override
    public long estimatedSize() {
        return this.data.mappingCount();
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<?> keys) {
        int hits = 0;
        int misses = 0;
        LinkedHashMap result = new LinkedHashMap();
        for (Object key : keys) {
            this.tracer().recordRead(this.id, key);
            V value = this.data.get(key);
            if (value == null) {
                ++misses;
                continue;
            }
            ++hits;
            Object castKey = key;
            result.put(castKey, value);
        }
        this.statsCounter.recordHits(hits);
        this.statsCounter.recordMisses(misses);
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public StatsCounter statsCounter() {
        return this.statsCounter;
    }

    void notifyRemoval(@Nullable K key, @Nullable V value, RemovalCause cause) {
        this.notifyRemoval(new RemovalNotification<K, V>(key, value, cause));
    }

    void notifyRemoval(RemovalNotification<K, V> notification) {
        Objects.requireNonNull(this.removalListener, "Notification should be guarded with a check");
        this.executor.execute(() -> this.removalListener.onRemoval(notification));
    }

    boolean hasRemovalListener() {
        return this.removalListener != null;
    }

    @Override
    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    @Override
    public boolean isRecordingStats() {
        return this.isRecordingStats;
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.data.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        if (!this.hasRemovalListener()) {
            this.data.replaceAll((key, value) -> {
                this.tracer().recordWrite(this.id, key, 1);
                return function.apply((K)key, (V)value);
            });
            return;
        }
        RemovalNotification[] notification = new RemovalNotification[1];
        this.data.replaceAll((key, value) -> {
            this.tracer().recordWrite(this.id, key, 1);
            if (notification[0] != null) {
                this.notifyRemoval(notification[0]);
                removalNotificationArray[0] = null;
            }
            Object newValue = Objects.requireNonNull(function.apply((K)key, (V)value));
            removalNotificationArray[0] = new RemovalNotification<Object, Object>(key, value, RemovalCause.REPLACED);
            return newValue;
        });
        if (notification[0] != null) {
            this.notifyRemoval(notification[0]);
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, boolean isAsync) {
        Objects.requireNonNull(mappingFunction);
        this.tracer().recordWrite(this.id, key, 1);
        Object value = this.data.get(key);
        if (value != null) {
            this.statsCounter.recordHits(1);
            return value;
        }
        boolean[] missed = new boolean[1];
        value = this.data.computeIfAbsent(key, k -> {
            blArray[0] = true;
            return this.statsAware(mappingFunction, isAsync).apply(key);
        });
        if (!missed[0]) {
            this.statsCounter.recordHits(1);
        }
        return value;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        this.tracer().recordWrite(this.id, key, 1);
        if (!this.data.containsKey(key)) {
            return null;
        }
        if (!this.hasRemovalListener()) {
            return this.data.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)this.statsAware(remappingFunction, false, false));
        }
        RemovalNotification[] notification = new RemovalNotification[1];
        Object nv = this.data.computeIfPresent(key, (k, oldValue) -> {
            Object newValue = this.statsAware(remappingFunction, false, false).apply(k, oldValue);
            removalNotificationArray[0] = newValue == null ? new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.EXPLICIT) : new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.REPLACED);
            return newValue;
        });
        if (notification[0] != null) {
            this.notifyRemoval(notification[0]);
        }
        return (V)nv;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean recordMiss, boolean isAsync) {
        this.tracer().recordWrite(this.id, key, 1);
        if (!this.hasRemovalListener()) {
            return this.data.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)this.statsAware(remappingFunction, recordMiss, isAsync));
        }
        RemovalNotification[] notification = new RemovalNotification[1];
        Object nv = this.data.compute(key, (k, oldValue) -> {
            Object newValue = this.statsAware(remappingFunction, recordMiss, isAsync).apply(k, oldValue);
            if (oldValue != null) {
                removalNotificationArray[0] = newValue == null ? new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.EXPLICIT) : new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.REPLACED);
            }
            return newValue;
        });
        if (notification[0] != null) {
            this.notifyRemoval(notification[0]);
        }
        return (V)nv;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        this.tracer().recordWrite(this.id, key, 1);
        if (!this.hasRemovalListener()) {
            return this.data.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)this.statsAware(remappingFunction));
        }
        RemovalNotification[] notification = new RemovalNotification[1];
        Object nv = this.data.merge(key, value, (oldValue, val) -> {
            Object newValue = this.statsAware(remappingFunction).apply(oldValue, val);
            removalNotificationArray[0] = newValue == null ? new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.EXPLICIT) : new RemovalNotification<Object, Object>(key, oldValue, RemovalCause.REPLACED);
            return newValue;
        });
        if (notification[0] != null) {
            this.notifyRemoval(notification[0]);
        }
        return (V)nv;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void clear() {
        if (!this.hasRemovalListener() && !Tracer.isEnabled()) {
            this.data.clear();
            return;
        }
        for (Object key : this.data.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getIfPresent(key, false);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.data.put(key, value);
        this.tracer().recordWrite(this.id, key, 1);
        if (this.hasRemovalListener() && oldValue != null && oldValue != value) {
            this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
        }
        return oldValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V oldValue = this.data.putIfAbsent(key, value);
        this.tracer().recordWrite(this.id, key, 1);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!this.hasRemovalListener() && !Tracer.isEnabled()) {
            this.data.putAll(map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V value = this.data.remove(key);
        this.tracer().recordDelete(this.id, key);
        if (this.hasRemovalListener() && value != null) {
            Object castKey = key;
            this.notifyRemoval(castKey, value, RemovalCause.EXPLICIT);
        }
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = this.data.remove(key, value);
        if (this.hasRemovalListener() && removed) {
            Object castKey = key;
            Object castValue = value;
            this.notifyRemoval(castKey, castValue, RemovalCause.EXPLICIT);
        }
        this.tracer().recordDelete(this.id, key);
        return removed;
    }

    @Override
    public V replace(K key, V value) {
        V prev = this.data.replace(key, value);
        if (this.hasRemovalListener() && prev != null && prev != value) {
            this.notifyRemoval(key, value, RemovalCause.REPLACED);
        }
        this.tracer().recordWrite(this.id, key, 1);
        return prev;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = this.data.replace(key, oldValue, newValue);
        if (this.hasRemovalListener() && replaced && oldValue != newValue) {
            this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
        }
        this.tracer().recordWrite(this.id, key, 1);
        return replaced;
    }

    @Override
    public boolean equals(Object o) {
        return this.data.equals(o);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        return ks == null ? (this.keySet = new KeySetView(this)) : ks;
    }

    @Override
    public Collection<V> values() {
        ValuesView vs = this.values;
        return vs == null ? (this.values = new ValuesView(this)) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySetView(this)) : es;
    }

    static final class UnboundedLocalAsyncLoadingCache<K, V>
    extends LocalAsyncLoadingCache<UnboundedLocalCache<K, CompletableFuture<V>>, K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Policy<K, V> policy;

        UnboundedLocalAsyncLoadingCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            super(UnboundedLocalAsyncLoadingCache.makeCache(builder), loader);
        }

        static <K, V> UnboundedLocalCache<K, CompletableFuture<V>> makeCache(Caffeine<K, V> builder) {
            return new UnboundedLocalCache<K, V>(builder, true);
        }

        @Override
        protected Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new UnboundedPolicy()) : this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy proxy = new SerializationProxy();
            proxy.isRecordingStats = ((UnboundedLocalCache)this.cache).isRecordingStats;
            proxy.removalListener = ((UnboundedLocalCache)this.cache).removalListener;
            proxy.ticker = ((UnboundedLocalCache)this.cache).ticker;
            proxy.loader = this.loader;
            proxy.async = true;
            return proxy;
        }
    }

    static final class UnboundedLocalLoadingCache<K, V>
    extends UnboundedLocalManualCache<K, V>
    implements LocalLoadingCache<UnboundedLocalCache<K, V>, K, V> {
        private static final long serialVersionUID = 1L;
        final CacheLoader<? super K, V> loader;
        final boolean hasBulkLoader;

        UnboundedLocalLoadingCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            super(builder);
            this.loader = loader;
            this.hasBulkLoader = this.hasLoadAll(loader);
        }

        @Override
        public CacheLoader<? super K, V> cacheLoader() {
            return this.loader;
        }

        @Override
        public boolean hasBulkLoader() {
            return this.hasBulkLoader;
        }

        @Override
        Object writeReplace() {
            SerializationProxy proxy = (SerializationProxy)super.writeReplace();
            proxy.loader = this.loader;
            return proxy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }

    static final class UnboundedPolicy<K, V>
    implements Policy<K, V> {
        UnboundedPolicy() {
        }

        @Override
        public Optional<Policy.Eviction<K, V>> eviction() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
            return Optional.empty();
        }

        @Override
        public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
            return Optional.empty();
        }
    }

    static class UnboundedLocalManualCache<K, V>
    implements LocalManualCache<UnboundedLocalCache<K, V>, K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final UnboundedLocalCache<K, V> cache;
        Policy<K, V> policy;

        UnboundedLocalManualCache(Caffeine<K, V> builder) {
            this.cache = new UnboundedLocalCache<K, V>(builder, false);
        }

        @Override
        public UnboundedLocalCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new UnboundedPolicy()) : this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy proxy = new SerializationProxy();
            proxy.isRecordingStats = this.cache.isRecordingStats;
            proxy.removalListener = this.cache.removalListener;
            proxy.ticker = this.cache.ticker;
            return proxy;
        }
    }

    static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        final UnboundedLocalCache<K, V> cache;
        final Iterator<Map.Entry<K, V>> iterator;
        Map.Entry<K, V> entry;

        EntryIterator(UnboundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
            this.iterator = cache.data.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.entry = this.iterator.next();
            return new WriteThroughEntry<K, V>(this.cache, this.entry.getKey(), this.entry.getValue());
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.entry != null);
            this.cache.remove(this.entry.getKey());
            this.entry = null;
        }
    }

    final class EntrySetView
    extends AbstractSet<Map.Entry<K, V>> {
        final UnboundedLocalCache<K, V> cache;

        EntrySetView(UnboundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = this.cache.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.cache);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return this.cache.data.entrySet().spliterator();
        }
    }

    static final class ValuesIterator<K, V>
    implements Iterator<V> {
        final UnboundedLocalCache<K, V> cache;
        final Iterator<Map.Entry<K, V>> iterator;
        Map.Entry<K, V> entry;

        ValuesIterator(UnboundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
            this.iterator = cache.data.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.entry = this.iterator.next();
            return this.entry.getValue();
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.entry != null);
            this.cache.remove(this.entry.getKey());
            this.entry = null;
        }
    }

    final class ValuesView
    extends AbstractCollection<V> {
        final UnboundedLocalCache<K, V> cache;

        ValuesView(UnboundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Objects.requireNonNull(o);
            return super.remove(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator(this.cache);
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.cache.data.values().spliterator();
        }
    }

    static final class KeyIterator<K>
    implements Iterator<K> {
        final UnboundedLocalCache<K, ?> cache;
        final Iterator<K> iterator;
        K current;

        KeyIterator(UnboundedLocalCache<K, ?> cache) {
            this.cache = Objects.requireNonNull(cache);
            this.iterator = ((ConcurrentHashMap.KeySetView)cache.data.keySet()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.current != null);
            this.cache.remove(this.current);
            this.current = null;
        }
    }

    static final class KeySetView<K>
    extends AbstractSet<K> {
        final UnboundedLocalCache<K, ?> local;

        KeySetView(UnboundedLocalCache<K, ?> local) {
            this.local = Objects.requireNonNull(local);
        }

        @Override
        public boolean isEmpty() {
            return this.local.isEmpty();
        }

        @Override
        public int size() {
            return this.local.size();
        }

        @Override
        public void clear() {
            this.local.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.local.containsKey(o);
        }

        @Override
        public boolean remove(Object obj) {
            return this.local.remove(obj) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator<K>(this.local);
        }

        @Override
        public Spliterator<K> spliterator() {
            return ((ConcurrentHashMap.KeySetView)this.local.data.keySet()).spliterator();
        }
    }
}

