/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import java.lang.ref.ReferenceQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

interface Node<K, V>
extends AccessOrderDeque.AccessOrder<Node<K, V>>,
WriteOrderDeque.WriteOrder<Node<K, V>> {
    @Nullable
    public K getKey();

    @Nonnull
    public Object getKeyReference();

    @Nullable
    public V getValue();

    @GuardedBy(value="this")
    public void setValue(@Nonnull V var1, @Nullable ReferenceQueue<V> var2);

    public boolean containsValue(@Nonnull Object var1);

    public boolean isAlive();

    public boolean isRetired();

    public boolean isDead();

    @GuardedBy(value="this")
    public void retire();

    @GuardedBy(value="this")
    public void die();

    @Nonnegative
    @GuardedBy(value="this")
    default public int getWeight() {
        return 1;
    }

    @Nonnegative
    @GuardedBy(value="this")
    default public void setWeight(int weight) {
    }

    default public long getAccessTime() {
        return 0L;
    }

    default public void setAccessTime(@Nonnegative long time) {
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getPreviousInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setPreviousInAccessOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getNextInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setNextInAccessOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }

    @Nonnegative
    default public long getWriteTime() {
        return 0L;
    }

    default public void setWriteTime(@Nonnegative long time) {
    }

    default public boolean casWriteTime(@Nonnegative long expect, @Nonnegative long update) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getPreviousInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setPreviousInWriteOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public Node<K, V> getNextInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    default public void setNextInWriteOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }
}

