/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter;
import com.github.benmanes.caffeine.cache.stats.DisabledStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.github.benmanes.caffeine.cache.tracing.Tracer;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Caffeine<K, V> {
    static final Supplier<StatsCounter> DISABLED_STATS_COUNTER_SUPPLIER = DisabledStatsCounter::get;
    static final Supplier<StatsCounter> ENABLED_STATS_COUNTER_SUPPLIER = ConcurrentStatsCounter::new;
    static final int UNSET_INT = -1;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int DEFAULT_EXPIRATION_NANOS = 0;
    static final int DEFAULT_REFRESH_NANOS = 0;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    int initialCapacity = -1;
    long refreshNanos = -1L;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalListener<? super K, ? super V> removalListener;
    Supplier<StatsCounter> statsCounterSupplier;
    Weigher<? super K, ? super V> weigher;
    Supplier<String> nameSupplier;
    Executor executor;
    Ticker ticker;
    Strength keyStrength;
    Strength valueStrength;

    private Caffeine() {
    }

    static void requireArgument(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(template, args));
        }
    }

    static void requireArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    static void requireState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    static void requireState(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(template, args));
        }
    }

    @Nonnull
    public static Caffeine<Object, Object> newBuilder() {
        return new Caffeine<Object, Object>();
    }

    @Nonnull
    public Caffeine<K, V> initialCapacity(@Nonnegative int initialCapacity) {
        Caffeine.requireState(this.initialCapacity == -1, "initial capacity was already set to %s", this.initialCapacity);
        Caffeine.requireArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @Nonnull
    public Caffeine<K, V> executor(@Nonnull Executor executor) {
        Caffeine.requireState(this.executor == null, "executor was already set to %s", this.executor);
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    @Nonnull
    Executor getExecutor() {
        return this.executor == null ? ForkJoinPool.commonPool() : this.executor;
    }

    @Nonnull
    public Caffeine<K, V> maximumSize(@Nonnegative long maximumSize) {
        Caffeine.requireState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        Caffeine.requireState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Caffeine.requireState(this.weigher == null, "maximum size can not be combined with weigher", new Object[0]);
        Caffeine.requireArgument(maximumSize >= 0L, "maximum size must not be negative", new Object[0]);
        this.maximumSize = maximumSize;
        return this;
    }

    @Nonnull
    public Caffeine<K, V> maximumWeight(@Nonnegative long maximumWeight) {
        Caffeine.requireState(this.maximumWeight == -1L, "maximum weight was already set to %s", this.maximumWeight);
        Caffeine.requireState(this.maximumSize == -1L, "maximum size was already set to %s", this.maximumSize);
        this.maximumWeight = maximumWeight;
        Caffeine.requireArgument(maximumWeight >= 0L, "maximum weight must not be negative", new Object[0]);
        return this;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> weigher(@Nonnull Weigher<? super K1, ? super V1> weigher) {
        Objects.requireNonNull(weigher);
        Caffeine.requireState(this.weigher == null);
        Caffeine.requireState(this.maximumSize == -1L, "weigher can not be combined with maximum size", this.maximumSize);
        Caffeine self = this;
        self.weigher = weigher;
        return self;
    }

    boolean evicts() {
        return this.getMaximumWeight() != -1L;
    }

    boolean isWeighted() {
        return this.weigher != null;
    }

    @Nonnegative
    long getMaximumWeight() {
        return this.weigher == null ? this.maximumSize : this.maximumWeight;
    }

    @Nonnull
    <K1 extends K, V1 extends V> Weigher<K1, V1> getWeigher(boolean isAsync) {
        Async.AsyncWeigher delegate = this.isWeighted() && this.weigher != Weigher.singleton() ? Weigher.bounded(this.weigher) : Weigher.singleton();
        return isAsync ? new Async.AsyncWeigher(delegate) : delegate;
    }

    @Nonnull
    public Caffeine<K, V> weakKeys() {
        Caffeine.requireState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        this.keyStrength = Strength.WEAK;
        return this;
    }

    boolean isStrongKeys() {
        return this.keyStrength == null;
    }

    boolean isWeakKeys() {
        return this.keyStrength == Strength.WEAK;
    }

    @Nonnull
    public Caffeine<K, V> weakValues() {
        Caffeine.requireState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Strength.WEAK;
        return this;
    }

    boolean isStrongValues() {
        return this.valueStrength == null;
    }

    boolean isWeakValues() {
        return this.valueStrength == Strength.WEAK;
    }

    boolean isSoftValues() {
        return this.valueStrength == Strength.SOFT;
    }

    @Nonnull
    public Caffeine<K, V> softValues() {
        Caffeine.requireState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Strength.SOFT;
        return this;
    }

    @Nonnull
    public Caffeine<K, V> expireAfterWrite(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Caffeine.requireState(this.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        Caffeine.requireArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
        this.expireAfterWriteNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getExpiresAfterWriteNanos() {
        return this.expiresAfterWrite() ? this.expireAfterWriteNanos : 0L;
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos != -1L;
    }

    @Nonnull
    public Caffeine<K, V> expireAfterAccess(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Caffeine.requireState(this.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        Caffeine.requireArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
        this.expireAfterAccessNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getExpiresAfterAccessNanos() {
        return this.expiresAfterAccess() ? this.expireAfterAccessNanos : 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos != -1L;
    }

    @Nonnull
    public Caffeine<K, V> refreshAfterWrite(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(unit);
        Caffeine.requireState(this.refreshNanos == -1L, "refresh was already set to %s ns", this.refreshNanos);
        Caffeine.requireArgument(duration > 0L, "duration must be positive: %s %s", new Object[]{duration, unit});
        this.refreshNanos = unit.toNanos(duration);
        return this;
    }

    @Nonnegative
    long getRefreshAfterWriteNanos() {
        return this.refreshes() ? this.refreshNanos : 0L;
    }

    boolean refreshes() {
        return this.refreshNanos != -1L;
    }

    @Nonnull
    public Caffeine<K, V> ticker(@Nonnull Ticker ticker) {
        Caffeine.requireState(this.ticker == null);
        this.ticker = Objects.requireNonNull(ticker);
        return this;
    }

    @Nonnull
    Ticker getTicker() {
        if (this.ticker != null) {
            return this.ticker;
        }
        return this.expiresAfterAccess() || this.expiresAfterWrite() || this.refreshes() || this.isRecordingStats() ? Ticker.systemTicker() : Ticker.disabledTicker();
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Caffeine<K1, V1> removalListener(@Nonnull RemovalListener<? super K1, ? super V1> removalListener) {
        Caffeine.requireState(this.removalListener == null);
        Caffeine self = this;
        self.removalListener = Objects.requireNonNull(removalListener);
        return self;
    }

    <K1 extends K, V1 extends V> RemovalListener<K1, V1> getRemovalListener(boolean async) {
        RemovalListener<? super K, ? super V> castedListener = this.removalListener;
        if (async && castedListener != null) {
            Async.AsyncRemovalListener<? super K, ? super V> asyncListener = new Async.AsyncRemovalListener<K, V>(castedListener, this.getExecutor());
            return asyncListener;
        }
        return castedListener;
    }

    @Nonnull
    public Caffeine<K, V> recordStats() {
        this.statsCounterSupplier = ENABLED_STATS_COUNTER_SUPPLIER;
        return this;
    }

    boolean isRecordingStats() {
        return this.statsCounterSupplier == ENABLED_STATS_COUNTER_SUPPLIER;
    }

    @Nonnull
    Supplier<? extends StatsCounter> getStatsCounterSupplier() {
        return this.statsCounterSupplier == null ? DISABLED_STATS_COUNTER_SUPPLIER : ENABLED_STATS_COUNTER_SUPPLIER;
    }

    @Nonnull
    public Caffeine<K, V> name(@Nonnull Supplier<String> nameSupplier) {
        Caffeine.requireState(this.nameSupplier == null);
        this.nameSupplier = Objects.requireNonNull(nameSupplier);
        return this;
    }

    @Nonnull
    String name() {
        if (Tracer.isEnabled()) {
            Supplier<String> named = this.nameSupplier == null ? Caffeine::callerClassName : this.nameSupplier;
            return named.get();
        }
        return "";
    }

    static String callerClassName() {
        String name;
        Class<?>[] classContext = new SecurityManager(){

            @Override
            public Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classContext != null) {
            for (Serializable serializable : classContext) {
                String pkg = ((Class)serializable).getPackage().getName();
                if (pkg.startsWith("com.github.benmanes.caffeine") || pkg.startsWith("java")) continue;
                name = ((Class)serializable).getSimpleName();
                int end = name.indexOf(36);
                if (name.isEmpty()) continue;
                return end == -1 ? name : name.substring(0, end);
            }
        }
        for (Serializable serializable : Thread.currentThread().getStackTrace()) {
            String className = ((StackTraceElement)serializable).getClassName();
            if (className.startsWith("com.github.benmanes.caffeine") || className.startsWith("java")) continue;
            name = ((StackTraceElement)serializable).getClassName().replaceAll("\\$[0-9]+", "\\$");
            int start = name.lastIndexOf(36);
            if (start == -1) {
                start = name.lastIndexOf(46);
            }
            return name.substring(start + 1);
        }
        return "Unknown";
    }

    boolean isBounded() {
        return this.maximumSize != -1L || this.maximumWeight != -1L || this.expireAfterAccessNanos != -1L || this.expireAfterWriteNanos != -1L || this.keyStrength != null || this.valueStrength != null;
    }

    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        this.requireWeightWithWeigher();
        this.requireNonLoadingCache();
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalManualCache(self) : new UnboundedLocalCache.UnboundedLocalManualCache(self);
    }

    @Nonnull
    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(@Nonnull CacheLoader<? super K1, V1> loader) {
        this.requireWeightWithWeigher();
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalLoadingCache<K1, V1>(self, loader) : new UnboundedLocalCache.UnboundedLocalLoadingCache<K1, V1>(self, loader);
    }

    @Nonnull
    public <K1 extends K, V1 extends V> AsyncLoadingCache<K1, V1> buildAsync(@Nonnull CacheLoader<? super K1, V1> loader) {
        Caffeine.requireState(this.valueStrength == null);
        this.requireWeightWithWeigher();
        Objects.requireNonNull(loader);
        Caffeine self = this;
        return this.isBounded() || this.refreshes() ? new BoundedLocalCache.BoundedLocalAsyncLoadingCache<K1, V1>(self, loader) : new UnboundedLocalCache.UnboundedLocalAsyncLoadingCache<K1, V1>(self, loader);
    }

    private void requireNonLoadingCache() {
        Caffeine.requireState(this.refreshNanos == -1L, "refreshAfterWrite requires a LoadingCache", new Object[0]);
    }

    private void requireWeightWithWeigher() {
        if (this.weigher == null) {
            Caffeine.requireState(this.maximumWeight == -1L, "maximumWeight requires weigher", new Object[0]);
        } else {
            Caffeine.requireState(this.maximumWeight != -1L, "weigher requires maximumWeight", new Object[0]);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(64);
        s.append(this.getClass().getSimpleName()).append('{');
        int baseLength = s.length();
        if (this.initialCapacity != -1) {
            s.append("initialCapacity=").append(this.initialCapacity).append(',');
        }
        if (this.maximumSize != -1L) {
            s.append("maximumSize=").append(this.maximumSize).append(',');
        }
        if (this.maximumWeight != -1L) {
            s.append("maximumWeight=").append(this.maximumWeight).append(',');
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.append("expireAfterWrite=").append(this.expireAfterWriteNanos).append("ns,");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.append("expireAfterAccess=").append(this.expireAfterAccessNanos).append("ns,");
        }
        if (this.refreshNanos != -1L) {
            s.append("refreshNanos=").append(this.refreshNanos).append("ns,");
        }
        if (this.keyStrength != null) {
            s.append("keyStrength=").append(this.keyStrength.toString().toLowerCase()).append(',');
        }
        if (this.valueStrength != null) {
            s.append("valueStrength=").append(this.valueStrength.toString().toLowerCase()).append(',');
        }
        if (this.removalListener != null) {
            s.append("removalListener").append(',');
        }
        if (s.length() > baseLength) {
            s.deleteCharAt(s.length() - 1);
        }
        return s.append('}').toString();
    }

    static enum Strength {
        STRONG,
        WEAK,
        SOFT;

    }
}

