#!/bin/bash

USERNAME=""
PASSWORD=""

verify_username()
{
    id -u $USERNAME > /dev/null
    if [ $? -ne 0 ]
    then
        echo "User $USERNAME is not valid"
        exit 1
    fi
}

verify_password()
{
    ORIGPASS=`grep -w "$USERNAME" /etc/shadow | cut -d: -f2`
    export ALGO=`echo $ORIGPASS | cut -d'$' -f2`
    export SALT=`echo $ORIGPASS | cut -d'$' -f3`
    GENPASS=$(perl -le 'print crypt("$ENV{PASSWORD}","\$$ENV{ALGO}\$$ENV{SALT}\$")')
    if [ "$GENPASS" == "$ORIGPASS" ]
    then
        echo "Valid Username-Password Combination"
        exit 0
    else
        echo "Invalid Username-Password Combination"
        exit 1
    fi
}

parse_args()
{
    if [ $# -ne 2 ]; then
        echo "./verify_password <username> <password>"
        exit 1
    fi

    USERNAME=$1
    shift
    PASSWORD=$1
    export PASSWORD
}

parse_args "$@"
verify_username
verify_password
