$("#login_submit").click(function(e){
  e.preventDefault();
  $(".error-input").removeClass("error-input");
  var validate = true;
  $("#loginForm input").each(function(ind){
    if($(this).val() === ""){
      validate = false;
      $(this).parent().addClass("error-input");

    }
  })
  if(!validate) return;

  loginAction();

  var user = $('#username').val();
  var pass = $('#password').val();

  $.ajax({
      url: '/validate_index',
      data: $('form').serialize(),
      type: 'POST',
      success: function (response) {
	var parsed_data = JSON.parse(response);
	console.log("Success response: ", parsed_data);
	if (parsed_data.status === "OK") {
          getNodeInformation(user, pass, parsed_data.nodetype);
        } else {
          if (parsed_data.status === "HyperScaleConfigured") {
            location.href = "/summary";
          } else if (parsed_data.status === "SetupInProgress") {
            location.href = "/processList";
          } else if (parsed_data.status === "ShowResumeDialog") {
            location.href = "/setup/resume";
          } else {
            location.href="/error_index";
          }
          postLogin();
        }
      },
      error: function(errormsg){
          let str_response = JSON.parse(errormsg.responseText);
          console.log("Error response: ", str_response);
          $(".responseError.form-group").show();
            $(".responseError.form-group").text(str_response.message);
          $("#username").click(function() {
            $(".responseError.form-group").hide();
          });
          $("#password").click(function() {
            $(".responseError.form-group").hide();
          });
        postLogin();
      }
  });
})

var loginAction = function() {
  $(".responseError.form-group").hide();
  $("#login_submit").prop("disabled", true);
  $("#login_text").css("display", "none");
  $("#spinner").css("display", "block");
}
	 
var postLogin = function() {
  $("#login_submit").prop("disabled", false);
  $("#login_text").css("display", "block");
  $("#spinner").css("display", "none");
  $("#username").prop("disabled", false);
  $("#password").prop("disabled", false); 
}

var getNodeInformation = function(username, password, nodetype) {
  var query_data = {
      user: username,
      pass: password
  }

  let node_type = {
      advancedNode: [{nodetype: nodetype}]
  }
  window.localStorage.setItem("backEndData", JSON.stringify(node_type));

  var json_query = JSON.stringify(query_data);
  $.ajax({
      url: '/setup/fresh',
      data: json_query,
      contentType: "application/json",
      type: 'POST',
      success: function (response) {
        var parsed_data = JSON.parse(response);
        if (parsed_data.status === "OK") {
          window.localStorage.setItem("backEndData", JSON.stringify(parsed_data));
          location.href = "/loadSetupHTML";
        } else {
          location.href="/error_index";
        }
        postLogin();
      },
      error: function(errormsg){
        let str_response = JSON.parse(errormsg.responseText);
        console.log("Error response: ", str_response);
        $(".responseError.form-group").show();
        $(".responseError.form-group").text(str_response.message);
        $("#username").click(function() {
        $(".responseError.form-group").hide();
      });
      $("#password").click(function() {
        $(".responseError.form-group").hide();
      });
        postLogin();
      }
  });
}

var initializeSetup = function() {
    if($("#check_manageNetwork").val() === 'on'){
      $(".node-info .input-inline").addClass("three-inputs");
    }
}

$("#reInstall_cancel").click(function(e){
    startOver()
})

$("#reInstall_resume").click(function(e){
    showServerProcess ("loading","Resuming install");
    enableProgressDial ("progress_loader", "Resuming install ...");

    var query_data = {
        dummy : ""
    }
    var json_query = JSON.stringify(query_data);

    var parsed_data = {
        restart_level: ''
    }

    $.ajax({
      url: '/query_restartlevel',
      data: json_query,
      type: 'POST',
      success: function (response) {
        var parsed_data = JSON.parse(response);
        if (parsed_data.restart_level === "deploy_hosted_engine") {
          alert("Previous setup failed while deploying hosted engine, so we need to cleanup before resuming setup");
          startOver()
        }
        else {
          location.href="/resume_setup";
        }
      },
      error: function(errormsg){
        let str_response = JSON.parse(errormsg.responseText);
        console.log("Error response: ", str_response);
        $(".responseError.form-group").show();
        $(".responseError.form-group").text(str_response.message);
      }
  });

})

//toggle button function
var changeToggleState = function(className) {
  $("#submit_step").attr("disabled",false);
  $(".error-input").removeClass("error-input");
  $(".no-validate").removeClass("no-validate");
  $("." + className).toggleClass("hide");

  if (isExistingCommServe()){
    window.model.clusterDetails[0]["existing_cs"] = true;
  } else {
    window.model.clusterDetails[0]["existing_cs"] = false;
  }
}

$(".step .toggle_step").click(function(e) {
  $(this).parent(".toggle").toggleClass("checked");
  changeToggleState($(this).attr("id"));
})

//works for ie9 and ie8
$(".step .toggle-img").click(function(e){
  $(this).parent(".toggle").toggleClass("checked");
  changeToggleState($(this).siblings("input").attr("id"));
})


var stepProcess = function(curStepNum, nextStepNum) {
  $("#submit_step").text(nextStepNum===3 ? 'Save' : 'Next');
  nextStepNum > 1 ? $("#back_step").removeClass("hide") : $("#back_step").addClass("hide");
  if(curStepNum < 3 || curStepNum > nextStepNum) {
    //page change
    $(".current_step").removeClass("current_step");
    $(".step.step-"+nextStepNum).addClass("current_step");
    $(".steps").removeClass("step-"+curStepNum).addClass("step-"+nextStepNum);
    //menu navigation
    if(curStepNum > nextStepNum) $(".menu.step-"+curStepNum).removeClass("selected");
    $(".menu.step-"+nextStepNum).addClass("selected");
  }
}


$("body").on("click",".no-validate .current_step input",function(e){
  $("#submit_step").attr("disabled",false);
  $(".error-input").removeClass("error-input");
  $(".no-validate").removeClass("no-validate");
})

$("#pwd").keyup(function() {
  existing_cs = isExistingCommServe();
  if (!existing_cs) {    
    pwdRuleCheck($(this).val());
  }
})

$("#window_product").keyup(function(){

  //initalize str without '-'
  var strArr =  $(this).val().split('-');
  var str = strArr.join('');

  strArr = [];
  var i=0;
  for(;i<str.length; i+=5){
    if(i > 24) break;
    var temp = str.slice(i,i+5);
    strArr.push(temp);
  }

  $(this).val(strArr.join('-').toUpperCase());

})

$("#standby_window_product").keyup(function(){

  //initalize str without '-'
  var strArr =  $(this).val().split('-');
  var str = strArr.join('');

  strArr = [];
  var i=0;
  for(;i<str.length; i+=5){
    if(i > 24) break;
    var temp = str.slice(i,i+5);
    strArr.push(temp);
  }

  $(this).val(strArr.join('-').toUpperCase());

})

var pwdRuleCheck = function(val, hint) {
  if (hint === undefined)
    hint = true;
  var validate = true;
  //check length of pwd
    if(val.length < 8) {
	if (hint)
	    $(".password_hint .rule-length").removeClass("validate")
    validate = false;
    } else {
	if (hint)
	    $(".password_hint .rule-length").addClass("validate");
  }

  //check uppercase
    if(val.match(/[A-Z]/g) === null) {
	if (hint)
	    $(".password_hint .rule-upper").removeClass("validate")
    validate = false;
    } else {
	if (hint)
	    $(".password_hint .rule-upper").addClass("validate");
  }

  //check lowercase
    if(val.match( /[a-z]/g) === null) {
	if (hint)
	    $(".password_hint .rule-lower").removeClass("validate")
    validate = false;
    } else{
	if (hint)
	    $(".password_hint .rule-lower").addClass("validate");
  }

  //check digit
    if(val.match(/[0-9]/g) === null) {
	if (hint)
	    $(".password_hint .rule-digit").removeClass("validate")
    validate = false;
    } else{
	if (hint)
	    $(".password_hint .rule-digit").addClass("validate");
  }

  //check special characters
    if(val.match( /[!@#$%^&*(),.?":{}|<>]/g) === null) {
	if (hint)
	    $(".password_hint .rule-special").removeClass("validate")
    validate = false;
    } else{
	if (hint)
	    $(".password_hint .rule-special").addClass("validate");
  }

  return validate;
}

var validateIP = function(id, ip) {

  if(id.indexOf("pwd") >= 0 || id ==='hostname' || id === 'window_product') return false;

  var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
  return !ip.match(ipformat)
}


var startOver = function() {
    showServerProcess ("loading","Cleaning up previous setup");
    enableProgressDial ("progress_loader", "Cleaning up previous setup ...");
    
    var query_data = {
        dummy : "" 
    }
    var json_query = JSON.stringify(query_data);

    var parsed_data = {
        status: 'FAILED'
    }

    $.ajax({
      url: '/start_over',
      data: json_query,
      type: 'POST',
      contentType: "application/json",
      success: function (response) {
        parsed_data = JSON.parse(response);
        if (parsed_data.status == "OK"){
            hideServerProcess ();
            disableProgressDial ("progress_loader");
            getNodeInformation("", "", "");
        } else {
            hideServerProcess ();
            disableProgressDial ("progress_loader");
            alert("Failed to cleanup previous setup, please retry");
            location.href = "/setup/resume";    
        }
      },
      error: function(errormsg){
        hideServerProcess ();
        disableProgressDial ("progress_loader");
        let str_response = JSON.parse(errormsg.responseText);
        console.log("Error response: ", str_response);
        $(".responseError.form-group").show();
        $(".responseError.form-group").text(str_response.message);
      }
  });
}


$("#back_step").click(function(e){
  e.preventDefault();
  var curStepNum = parseInt($(".current_step").attr("data-step"));
  if(curStepNum !=1) stepProcess(curStepNum,curStepNum-1);
})


var showACscreenshots = function(index){
  var baseUrl = 'static/screenshots/slide';
  var numSlides = 10;  
  var currentSlide = index % numSlides; 
  $("#ac_screenshots").attr("src",baseUrl+currentSlide.toString()+'.png');
}

//error show for element
//ele shoudl start #
var showErrorForNode = function(ele,errMsg) {
  var parentNode = $(ele).parent();

  if($(".current_step").attr("data-step") == 1) {
    parentNode = $(ele).parents('.node-info').length === 0 ? $(ele).parent() : $(ele).parents(".node-info");
  }

  parentNode.children(".error").text(errMsg? errMsg : 'Please fill out node information.');  
  $(parentNode).addClass("error-input");
  $("#submit_step").attr("disabled","true");
  $(".steps").addClass("no-validate");

}

//state : loading or error
var showServerProcess = function(state,msg) {
  $(".responseError .error").text(msg);
  (state === 'loading')? $(".responseError .error").addClass("loading") : $(".responseError .error").removeClass("loading");
  $(".responseError").addClass("error-input");
}

var hideServerProcess = function() {
  $(".responseError").removeClass("error-input")
}

var enableProgressDial = function(ele,msg) {
  $("#"+ele).removeClass("hide");
  $("#resume_dialog").addClass("hide");
  $(".dialog-resume-body").text(msg);
}

var disableProgressDial = function(ele) {
  $("#"+ele).addClass("hide");
}

var changeProgress = function(percentage, stage) {
  if(stage) {
    $("#process-state .process-text .stage").text(stage);
  }
  if(!isNaN(percentage) && percentage >= 0 && percentage <= 100) {
    $("#process-state .progress-bar>div").width(percentage + '%');
    $("#process-state .process-text .percentage>span:first-child").text(percentage);
  } 
}


var isPrimaryCommServe = function() {
  return $('#primary-cs-toggle')[0].checked;
}

var isAdditionalCommServe = function() {
  return $('#additional-cs-toggle')[0].checked;
}

var isStandbyKvmCommServe = function() {
  return $('#standbykvmcs-toggle')[0].checked;
}

var isExistingCommServe = function() {
  return !(isPrimaryCommServe() || isAdditionalCommServe() || isStandbyKvmCommServe());
}

var isExistingCommServeToggle = function() {
  existing_cs = isExistingCommServe();
  if (existing_cs) {
    return "on";
  } else {
    return "off";
  }
}

var isAdditionalCommServeToggle = function() {
  additional_cs = isAdditionalCommServe();
  if (additional_cs) {
    return "on";
  } else {
    return "off";
  }
}

var isStandbyKvmCommServeToggle = function() {
  standbykvm_cs = isStandbyKvmCommServe();
  if (standbykvm_cs) {
    return "on";
  } else {
    return "off";
  }
}

var enableSimpleBond = function() {
    $("simple-bond-toggle").attr("checked", true);
}


var hideSimpleBond = function() {
    $(".toggle.form-group.additional-toggle-step").hide();
}

var unhideSimpleBond = function() {
    $(".toggle.form-group.additional-toggle-step").show();
}

var showInstallComplete = function(state,problems) {
  if(state === 'success') {
    $("#summary-dialog").addClass("successful").removeClass("warning");
  } else if(state === 'warning') {
    $("#summary-dialog").addClass("warning").removeClass("successful");
    if(problems) {
      console.log("Problems: ", problems);
      problems.forEach(function(val){
        $("#summary-warning-list").append("<li>"+val+"</li>")
      })
    }
  }
}

