#!/usr/bin/python
import sys
import time
import ConfigParser
import utils

#Create a logger
logger = utils.Logger ("hyperscale")
log_file_path = logger.getFilePath()

output_filepath = ""

import cvavahi

try:
    import avahi
    import dbus
    from dbus.mainloop.glib import DBusGMainLoop
    import gobject

except ImportError, e:
    Logger.log_warning ("Python module missing: %s\n" %(e))
    sys.exit (1)

class AvahiBrowse ():
    def __init__ (self, service):
        loop                = DBusGMainLoop(set_as_default = True)
        self.interface      = avahi.IF_UNSPEC
        self.proto          = avahi.PROTO_UNSPEC
        self.service_type   = service
        self.browser        = None
        self.output         = {}

        try:
            self.bus = dbus.SystemBus (mainloop = loop)
            self.server = dbus.Interface (self.bus.get_object (avahi.DBUS_NAME,
                                          avahi.DBUS_PATH_SERVER),
                                          avahi.DBUS_INTERFACE_SERVER)
        except dbus.DBusException:
            Logger.log_warning ("Failed to connect to Avahi Server "
                            "(Is it running?).")
            sys.exit (1)

        self.browser = dbus.Interface (self.bus.get_object (avahi.DBUS_NAME, 
                                       self.server.ServiceBrowserNew (self.interface,
                                       self.proto, self.service_type, 'local',
                                       dbus.UInt32(0))),
                                       avahi.DBUS_INTERFACE_SERVICE_BROWSER)

        self.browser.connect_to_signal ("ItemNew", self.new_service)
        self.browser.connect_to_signal ("AllForNow", self.quit)

        self.mainloop = gobject.MainLoop ()

    def resolved_service (self, interface, protocol, name, stype, domain,
                          host, proto, ip, port, txt, flags):
        if host.endswith (".local"):
            new_host = host[:-6]
        this_service = "ip:" + ip + " " + "host:" + new_host + " " + "txt:" + str (avahi.txt_array_to_string_array (txt))
        self.output [name] = this_service

    def resolver_error (self, err):
        Logger.log_info ("Something went wrong: ", str(err))

    def new_service (self, interface, protocol, name, service, domain, flags):
        self.server.ResolveService (interface, protocol, name, self.service_type, domain,
                                    avahi.PROTO_INET, dbus.UInt32(0),
                                    reply_handler = self.resolved_service,
                                    error_handler = self.resolver_error)

    def fix_name_conflict(self, service_name):
        fields = []
        fields = service_name.split ("#")
        return fields[0].rstrip()

    def quit (self):
        Config = ConfigParser.ConfigParser ()
        cfgfile = open (output_filepath, "w+")
        
        for name in self.output:
            # In case of conflicts remove the '# <num>" characters from service name
            name_wo_hash = self.fix_name_conflict(name)            

            if (name_wo_hash == "hsimaging"):
                continue

            if (not Config.has_section(name_wo_hash)):
                Config.add_section (name_wo_hash)

            avahi_fields = self.output[name].split ("txt:")
            avahi_fields[0] = avahi_fields[0].rstrip()
            pairs = avahi_fields[0].split (" ")
            for pair in pairs:
                keyvalue = pair.split (":")
                Config.set (name_wo_hash, keyvalue[0], keyvalue[1])
            dict = cvavahi.parse_avahi_config_txtrecord(avahi_fields[1])
            for key in dict.keys():
                Config.set (name_wo_hash, key, dict[key])

        Config.write (cfgfile)
        cfgfile.close()
        self.mainloop.quit ()

    def browse (self):
        self.mainloop.run ()

def validate_and_parse_arguments():
    global output_filepath

    if len(sys.argv) != 2:
        print "Syntax: ./avahi_browse_and_print.py <output_file>"
        sys.exit (-1)
    output_filepath = sys.argv[1]

def main ():
    service = "_CommVaultAppliances._tcp"
    browser = AvahiBrowse (service)
    browser.browse ()

def init (filepath):
    global output_filepath

    output_filepath = filepath
    main()

if __name__ == "__main__":
    validate_and_parse_arguments()
    main ()
    sys.exit (0)
