#!/opt/hedvig/bin/python
import sys
sys.path.append('/usr/local/hedvig/scripts/spm')
import spmcommon
import argparse
import logging

log_file_path = "/var/log/cvspmhelper.log"
logging.basicConfig(filename=log_file_path, format='%(asctime)s : %(levelname)s : %(message)s',
                    datefmt='%m/%d/%Y %I:%M:%S %p', level=logging.DEBUG)

def list_all_data_drives ():
    mysid = spmcommon.get_my_storageid () 
    faileddrives=spmcommon.get_failed_drives_in_pool(mysid)
    alldrives = spmcommon.get_all_drives_in_pool(mysid)

    result = []
    for dr in alldrives:
        if (faileddrives and dr in faileddrives):
            result.append (dr + "0|")
        else:
            result.append (dr + "1|")
    
    return result 

def check_if_mntpath_in_pool (input_path):
    mysid = spmcommon.get_my_storageid () 
    faileddrives=spmcommon.get_failed_drives_in_pool(mysid)
    alldrives = spmcommon.get_all_drives_in_pool(mysid)
    
    if (alldrives == []):
        sys.exit (1) 

    result = ""
    for dr in alldrives:
        arr = dr.split("|")
        mntpath = arr[2] 
        if (mntpath  != input_path):
            continue
        failed = False
        if (faileddrives and dr in faileddrives):
            result = dr + "0|"
        else:  		 
            result = dr + "1|"
	print result
	sys.exit (0)		
        
command_usage = {
        "list_data_drives":"List data drives used by hedvig clusters\n",
        "get_storagepool_id":"Given a mount path (e.g. /hedvig/d3 prints storage id for the drive\n"
       }

def usage():
    global command_usage
    print "cvavahi : Command line interface to update cvlt avahi service"
    for key in command_usage.keys():
        print command_usage[key]
    sys.exit(1)

valid_argcnt = {
        "list_data_drives":0,
        "get_storagepool_id":1
       }

def validate_arguments():
    global command_usage
    valid_commands = ["list_data_drives", "get_storagepool_id"]

    if (len(sys.argv) == 1) or (len(sys.argv) > 1 and (sys.argv[1] not in valid_commands)):    
        for key in command_usage.keys():
            print key + "\t:" + command_usage[key]   
        sys.exit(1)

    args_needed = 2 + valid_argcnt[sys.argv[1]]
    if (args_needed > len(sys.argv)):
        print command_usage[sys.argv[1]]
        sys.exit(1)

validate_arguments ()
if (sys.argv [1] == "list_data_drives"):
    drlist = list_all_data_drives ()
    if (len (drlist) == 0):
        sys.exit (1)
    for dr in drlist:
        print dr
    sys.exit (0)

if (sys.argv [1] == "get_storagepool_id"):
    check_if_mntpath_in_pool (sys.argv[2])

