#-*- coding: utf-8 -*-


"""Classes representing option types."""


class TextOption(object):
    """User is expected to provide data in form of text."""

    def __init__(self, name, defaultVal="", maxlen=0, short_desc=None, help_text=None):
        """Initialization of a TextOption instance."""

        self.name = name
        if defaultVal is None:
            defaultVal = ''
        self.defaultVal = defaultVal
        self.maxlen = maxlen
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None


class BoolOption(object):
    """User is expected to provide a boolean value."""

    #def __init__(self, name, short_desc=None, help_text=None, selected=False):
    def __init__(self, name, short_desc=None, help_text=None, selected=False, actionListner=None):
        """Initialization of a BoolOption instance."""
        self.name = name
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None
        self.selected = selected
        if(hasattr(actionListner, '__call__')):
            self.actionListner = actionListner
        else:
            self.actionListner = None

    def changeVal(self, newVal, do_callback=True):
        """Change the value of the checkbox
        newVal Can have 3 values :
            True    - [X]
            False   - [ ]
        """
        if str(newVal) in ['True', 'False']:
            if self.widgetRef is not None:
                self.widgetRef.change(newVal, do_callback)

    def changeActionListener(self, newHandler):
        """ Change the action listener """
        if(hasattr(newHandler, '__call__')):
            self.actionListner = newHandler
            self.widgetRef.changeActionListener(newHandler)

    def disableOption(self):
        """ To Diable option"""
        if self.widgetRef is not None:
            self.widgetRef.disable(True)

    def enableOption(self):
        """ To enable option"""
        if self.widgetRef is not None:
            self.widgetRef.disable(False)


class ExclusiveOptionList(object):
    """User is expected to select one option from a list."""

    def __init__(self, *options):
        """Initialization of an ExclusiveOptionList instance."""

        self.options = list(options)
        self.widgetRef = None

    def __iter__(self):
        """Make this object iterable.

        """
        return iter(self.options)

    def append(self, option):
        """Append an option to the list.

        """
        self.options.append(option)

    def add_option(self, name=None, selected=False, tooltip=None, help=None):
        """Add an option to the options list

        """
        self.append(dict(name=name, selected=selected, tooltip=tooltip, help=help))

    def select_option(self, num):
        """select an option by default"""
        if self.widgetRef is None:
            self.options[num]['selected'] = True
        else:
            self.widgetRef.set_option(num)


class CheckBoxList(object):
    """User is expected to select multiple options from list."""

    def __init__(self, *options):
        """Initialization of an CheckBoxList instance."""

        self.options = list(options)
        self.widgetRef = None

    def __iter__(self):
        """Make this object iterable.

        """
        return iter(self.options)

    def append(self, option):
        """Append an option to the list.

        """
        self.options.append(option)

    def add_option(self, name=None, selected=False, tooltip=None, help=None):
        """Add an option to the options list

        """
        self.append(dict(name=name, selected=selected, tooltip=tooltip, help=help))


class NumericOption(object):
    """User is expected to provide a numeric value."""

    def __init__(self, name, defaultVal=0, minvalue=0, maxvalue=0, short_desc=None, help_text=None):
        """Initialization of a NumericOption instance."""

        self.name = name
        if defaultVal is None:
            defaultVal = ''
        self.defaultVal = defaultVal
        self.minvalue = minvalue
        self.maxvalue = maxvalue
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None

        
class IPAddress(object):
    """Internet Protocol model."""

    def __init__(self, name, defaultVal="", short_desc = None, help_text = None):

        self.name = name
        if defaultVal is None:
            defaultVal = ''
        self.defaultVal = defaultVal
        self.short_desc = short_desc
        self.help_text = help_text


class SimpleText(object):
    """informative text label.
    """

    process = False

    def __init__(self, text, short_desc=None, help_text=None):
        """SimpleText initialization.

        """
        self.text = text
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None

    def changeText(self, newVal):
        """change the text even after rendring"""
        oldText = self.widgetRef.text
        self.widgetRef.change(newVal)
        return oldText


class FormattedText(object):
    """informative formatted text label.
    """

    process = False

    class Color:
        """ Foreground colors enumeration"""
        class FG:
            BLACK = 'black'
            DARK_RED = 'dark red'
            DARK_GREEN = 'dark green'
            BROWN = 'brown'
            DARK_BLUE = 'dark blue'
            DARK_MAGENTA = 'dark magenta'
            DARK_CYAN = 'dark cyan'
            LIGHT_GRAY = 'light gray'
            DARK_GRAY = 'dark gray'
            LIGHT_RED = 'light red'
            LIGHT_GREEN = 'light green'
            YELLOW = 'yellow'
            LIGHT_BLUE = 'light blue'
            LIGHT_MAGENTA = 'light magenta'
            LIGTH_CYAN = 'light cyan'
            WHITE = 'white'

        """ Background colors enumeration"""
        class BG:
            BLACK = 'black'
            DARK_RED = 'dark red'
            DARK_GREEN = 'dark green'
            BROWN = 'brown'
            DARK_BLUE =  'dark blue'
            DARK_MAGENTA = 'dark magenta'
            DARK_CYAN = 'dark cyan'
            LIGHT_GRAY = 'light gray'

    def __init__(self, text, fg_fmt = 'default', bg_fmt = 'default'):
        """Formatted text initialization.
        fg_fmt: its the foreground format & can be specified like 'Color.FG.RED, bold, underline'
        bg_fmt: its the background format & can be specified like 'Color.BG.BLACK'

        """
        self.text = text
        self.widgetRef = None
        self.fg_fmt = fg_fmt
        self.bg_fmt = bg_fmt 


    def changeText(self, newVal):
        """change the text even after rendring"""
        oldText = self.widgetRef.text
        self.widgetRef.change(newVal)
        return oldText


class LongListBox(object):
    """To display multiline pile

    """

    def __init__(self, pileList, displayCount=2, short_desc=None, help_text=None):
        """LongList Box initialization.

        """
        self.pileList = pileList or []
        self.displayCount = displayCount
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None


class PasswordTextOption(object):
    """User is expected to provide password which is masked."""

    def __init__(self, name, defaultVal="", maxlen=0, short_desc=None, help_text=None):
        """Initialization of a TextOption instance."""
        self.name = name
        self.defaultVal = defaultVal
        self.maxlen = maxlen
        self.short_desc = short_desc
        self.help_text = help_text
        self.widgetRef = None
