# -*- coding: utf-8 -*-

import os
import sys
import codecs
import re
import locale
import re
import ast
import cvpylogger

langdictObj = {}
engdictObj = {}
languageExtdict = {'en_US': 'eng', 'zh_CN': 'chn', 'zh_TW': 'cht', 'fr_FR': 'frn', 'fr_CA': 'fra',
                   'de_DE': 'ger', 'it_IT': 'ita', 'ja_JP': 'jpn', 'ko_KR': 'kor', 'pt_BR': 'por',
                   'ru_RU': 'rus', 'es_ES': 'spa', 'es_MX': 'mex'}
encodingDict = {'en_US': 'utf-8', 'zh_CN': 'utf-8', 'zh_TW': 'utf-8', 'fr_FR': 'utf-8', 'fr_CA': 'utf-8',
                'de_DE': 'utf-8', 'it_IT': 'utf-8', 'ja_JP': 'utf-8', 'ko_KR': 'utf-8', 'pt_BR': 'utf-8',
                'ru_RU': 'utf-8', 'es_ES': 'utf-8', 'es_MX': 'utf-8'}
LOCALIZED_STRING_LOCATION = 'ApplianceSetup.%s'
ENABLE_LOCALIZATION = False


class NoLanguageStringError(Exception):
    """Exception raised when corresponding localized string is not found
    in language file"""
    def __init__(self, langExt, stringKey):
        """langExt is the locale type of language where string not found"""
        self.langExt = langExt
        self.stringKey = stringKey

    def __str__(self):
        return "No language string found for key (%s) for locale (%s)" % (self.stringKey, self.langExt)

ESCAPE_SEQUENCE_RE = re.compile(r'''
    ( \\U........      # 8-digit hex escapes
    | \\u....          # 4-digit hex escapes
    | \\x..            # 2-digit hex escapes
    | \\[0-7]{1,3}     # Octal escapes
    | \\N\{[^}]+\}     # Unicode characters by name
    | \\[\\'"abfnrtv]  # Single-character escapes
    )''', re.UNICODE | re.VERBOSE)


def decode_escapes(s):
    def decode_match(match):
        return codecs.decode(match.group(0), 'unicode-escape')

    return ESCAPE_SEQUENCE_RE.sub(decode_match, s)


def updateDict(localefile, englishLang=False):
    """
    Update the Language string dictionary
    """
    global langdictObj
    global engdictObj
    dictObj = {}
    with codecs.open(localefile, "r", encoding='utf-8') as rf:
        for eachLine in rf.readlines():
            eachLine = eachLine.strip()
            if eachLine.startswith('#') or eachLine.startswith('--'):
                continue
            elif len(eachLine) > 2:
                split, key, value = re.split('^(\S+)*', eachLine)
                key = key.strip()
                if key.startswith(u'\ufeff'):
                    key = key.replace(u'\ufeff', '')
                value = value.strip()
                dictObj[key] = value
    if englishLang:
        engdictObj = dictObj
    else:
        langdictObj = dictObj


def getLocalizedString(key):
    global langdictObj
    global engdictObj
    log = cvpylogger.getLog()
    if engdictObj == {}:
        engFileExt = languageExtdict['en_US']
        fileName = LOCALIZED_STRING_LOCATION % (engFileExt)  # Need to modify the Files name
        updateDict(fileName, True)
    if langdictObj == {}:
        (langCode, encoding) = getLocale()
        langFileExt = languageExtdict[langCode]
        fileName = LOCALIZED_STRING_LOCATION % (langFileExt)  # Need to modify the Files name
        if os.path.exists(fileName):
            updateDict(fileName)
    if key in langdictObj.keys():
        return decode_escapes(langdictObj[key])
    else:
        if engdictObj[key] is not None:
            log.debug("No language string found for key (%s) for locale (%s)" % (getLocale()[0], key))
            return engdictObj[key]
        else:
            raise NoLanguageStringError(getLocale()[0], key)


def getEnglishStringForMsg(msg):
    global engdictObj
    global langdictObj
    (langCode, encoding) = getLocale()
    if langCode == 'en_US':
        return msg
    else:
        keyVal = None
        for key, value in langdictObj.iteritems():
            if value == msg:
                keyVal = key
        if keyVal is None:
            return msg
        else:
            return engdictObj[key]


def getLocale():
    """
    If the default locale on the machine is not supported or not known, fall back to en_US
    """
    if not ENABLE_LOCALIZATION:
        return ('en_US', 'utf-8')
    (langCode, encoding) = locale.getdefaultlocale()
    if langCode is None:
        langCode = 'en_US'
    try:
        encoding = encodingDict[langCode]
    except KeyError:
        (langCode, encoding) = ('en_US', 'utf-8')
    return (langCode, encoding)

if __name__ == '__main__':
    k = getLocalizedString("WELCOME_PAGE_TITLE")
    print(k)
