function valthis(pageIdentifier) {
  if (pageIdentifier === 1) {
    if ($(".OSCheckBox:checked").length < 1) {
      showError("Please select a disk for OS install");
      return false;
    }
  }

  if (pageIdentifier === 2) {
    if ($(".metaCheckBox:checked").length < 1) {
      showError("Please select a disk for Metadata install");
      return false;
    }
  }

  if (pageIdentifier === 3) {
    if ($(".dataCheckBox:checked").length < 1) {
      showError("Please select a Data disk");
      return false;
    }
  }

}


function installSuccess(url) {
  window.location.replace(url);
}



function checkStatusChecked() {
  if (!document.getElementById('status1').checked 
      && !document.getElementById('status2').checked) {
      var x = document.getElementById("errorText");
      x.style.display = "block";
      return false;
  }
  return true;
}


function changeProgress(node, percentage, stage) {
    let node_suffix = node.replace(/[\.]/g, "");
    $("#" + node_suffix.toString() + " .process-text .stage").text(stage);
    $("#" + node_suffix.toString() + " .progress-bar>div").width(percentage + '%');
    $("#" + node_suffix.toString() + " .process-text .percentage>span:first-child").text(percentage);
}


function getProgress() {
    $.ajax({
	url: 'getprogress',
	type: 'GET',
	success: function (response) {
	    var parsed_data = JSON.parse(response);
	    let completed = true;
	    for (let i in parsed_data) {
		console.log("N: ", i, " P: ", parsed_data[i].percent, " M: ", parsed_data[i].message, " S: ", parsed_data[i].status);
                changeProgress(i, parsed_data[i].percent, parsed_data[i].message);
		if (parsed_data[i].percent !== 100 || parsed_data[i].status !== "success")
		    completed = false;
	    }
	    if (completed)
		installSuccess('/installationSuccessful');
	},
	error: function(errormsg){
	    let str_response = JSON.parse(errormsg.responseText);
	    console.log("Error response: ", str_response);
	    window.location.replace('/warning/statusupdate');
	}
    });
}


function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

async function changeStates() {
    // Assumes total imaging time is 1800 secs (30 min)
    const c_polltime = 10000;   // 10s in ms
    const c_numpolls = 180;

    var i = 0;
    do
    {
	getProgress();
        await sleep(c_polltime);
        ++i;
    } while(i < c_numpolls);

    window.location.replace('/warning/timeout');
}



function showError(message)
{
  $("#displayError").text(message);
  $("#displayError").show();
  if ($("#nextbutton"))
    $("#nextbutton").attr("disabled", true);
}


function clearErrors()
{
  $("#displayError").hide();
  $("#nextbutton").attr("disabled", false);
}


$(function () {
  // Allows only one disk for OS install
  $(".OSCheckBox").click(function() {
    if ($(".OSCheckBox:checked").length > 1)
    {
      showError("Please ensure that a single disk is selected");
    } else {
      clearErrors();
    }
  });

  // Allows only one disk for metadata install
  $(".metaCheckBox").click(function() {
    if ($(".metaCheckBox:checked").length > 1)
    {
      showError("Please ensure that a single disk is selected");
    } else {
      clearErrors();
    }
  });

  // Allows minimum of 2 disks as data disks
  $(".dataCheckBox").click(function() {
    if ($(".dataCheckBox:checked").length < 2)
    {
      showError("Please ensure that a minimum of 2 disks are selected");
    } else {
      clearErrors();
    }
  });

  // Allows multiple of 2 disks as data disks
  $(".dataCheckBox").click(function() {
    if ($(".dataCheckBox:checked").length % 2 !== 0)
    {
      showError("Please ensure that multiples of 2 disks are selected");
    } else {
      clearErrors();
    }
  });

  // divs marked as hidden will not be shown. Easier to unhide them in future
  $(".hide").hide();

});

