#!/bin/python
import wrappers
import utils
import sys
import collections
import urwid

drives_type=""
mode_info_file=""
hashmap={ }
trigger=False
first_mode="empty"

def extract_params():
    global mode_info_file
    global drives_type  
    drives_type=sys.argv[1]     
    mode_info_file=sys.argv[2]

def usage(cmd):
    print "usage: "+cmd+" <drives_type> <file containing the supported installation mode>"

def rblist(header_str,desc,hashmap): 
    global first_mode 
    body = [urwid.Text(header_str,align='center')]
    body.append(urwid.Text(desc))
    od = collections.OrderedDict(sorted(hashmap.items()))
    rbgroup = [ ] #Radio button group
    for mode,status in od.iteritems():
        if (first_mode=="empty"):
            first_mode=mode
        rb = urwid.RadioButton(rbgroup,mode)  
        urwid.connect_signal(rb, 'change', item_chosen, hashmap)
        body.append(rb)
    button = urwid.Button("OK")
    urwid.connect_signal(button, 'click', ok_chosen)
    body.append(button)
    return urwid.ListBox(urwid.SimpleFocusListWalker(body))
     
def item_chosen(rb,new_state,hashmap):
    global trigger 
    label=rb.get_label()
    if (True==new_state):
        hashmap[label]="true"
    else:  
        hashmap[label]="false"
    trigger=True

def ok_chosen(button):
    #Backup the existing devicemap file.
    file_name=mode_info_file+".bmr"
    wrappers.copy(mode_info_file,file_name)
    #Write the modified hashmap to device map file.
    if (False==trigger): 
        hashmap[first_mode]="true"         
    wrappers.save_hashmap(mode_info_file,hashmap)
    raise urwid.ExitMainLoop()

def init_mode_file():
    filep=utils.File(mode_info_file,"w")
    filep.write("Reinitialize drives:\n")
    filep.write("Preserve drives:\n")
    filep.close()

len=len(sys.argv)
if (len<>3):
    usage(sys.argv[0])
    sys.exit(1)  

extract_params()
init_mode_file()
hashmap=wrappers.set_hashmap(mode_info_file,"false")
heading=wrappers.get_commvault_title()
description="\n"
if (drives_type=="data"):
    description+="Please select whether the SAS drives containing valid Commvault backup data needs to be reinitialized.\n"
    description+="As part of reinitialization the drives will be formatted with a new file system layout.\n"
    description+="This will destroy any existing backup data on the drives\n\n"
elif (drives_type=="system"):
    description+="Please select whether the system drives containing operating system files,ddb and index cache needs to be reinitialized.\n"
    description+="As part of reinitialization the drives will be formatted with a new file system layout.\n"
    description+="This will destroy any existing operating system files,ddb and index cache on the drives\n\n"

main = urwid.Padding(rblist(heading,description,hashmap))
urwid.MainLoop(main).run()
