#!/bin/ksh
LogMessage()
{
	echo $1 >> $LOGDIR	
}

if [ "$1" == "" ]; then
echo "Usage: $0 Output-Directory"
exit
fi

EULA=eula.txt
LOGDIR="$1/EDC_DATA/log.txt"

if [[ ! -f $EULA ]]; then
	echo "The end user license file does not exist. Please make sure that you copy the file $EULA"
	exit 1
fi

more $EULA
echo -n "Do you accept the terms and conditions(Y/N)?"
read eula_agreement

if [[ "$eula_agreement" != "Y" && "$eula_agreement" != "y" ]]; then
	echo "Exiting the program as the EULA was not accepted"
	exit 1
fi

DIR="$1/EDC_DATA"

mkdir -p $DIR
if [ $? -ne 0 ]; then
echo "Failed to create the output directory. Please check if the given path exists"
exit $?
fi 

if [[ -f $LOGDIR ]]; then
	echo "Removing old predeployment_log.txt"
	rm -rf $LOGDIR
fi



set CLOUDVERSIONFILE=CloudScriptVersion.txt
head -1 edc_networker.sh > $DIR/$CLOUDVERSIONFILE

LogMessage "Parameters:OUTDIR:$DIR"
LogMessage "Collecting server information"
echo print type:NSR	| nsradmin -i - 1>$DIR/edc_server.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect server information"
LogMessage "Failed to collect server information"
fi

echo print type:NSR Client	| nsradmin -i - 1>$DIR/edc_client.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect client information"
LogMessage "Failed to collect client information"
fi

LogMessage "Collecting storage node information"
echo print type:NSR Storage Node	| nsradmin -i - 1>$DIR/edc_storagenode.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect storage node information"
LogMessage "Failed to collect storage node information"
fi

LogMessage "Collecting directive information"
echo print type:NSR Directive | nsradmin -i - 1>$DIR/edc_directive.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect directive information"
LogMessage "Failed to collect directive information"
fi

LogMessage "Collecting schedule information"
echo print type:NSR Schedule 	| nsradmin -i - 1>$DIR/edc_schedule.txt 2>&1 
if [ $? -ne 0 ]; then
echo "Failed to schedule information"
LogMessage "Failed to collect schedule information"
fi

LogMessage "Collecting group information"
echo print type:NSR Group 	| nsradmin -i - 1>$DIR/edc_group.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect group information"
LogMessage "Failed to collect group information"
fi

LogMessage "Collecting job information through mminfo command"
mminfo -xc, -aocnt -r "group,client,name,level,nsavetime,totalsize,sscomp(25),nfiles,volume,location,volid,barcode" 1>$DIR/edc_jobs.txt 2>&1 
if [ $? -ne 0 ]; then
echo "Failed to collect job information"
LogMessage "Failed to collect job information"
fi

LogMessage "Collecting jukebox information"
echo print type:NSR jukebox 	| nsradmin -i - 1>$DIR/edc_libraries.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect jukebox information"
LogMessage "Failed to collect jukebox information"
fi

LogMessage "Collecting device information"
echo print type:NSR device 	| nsradmin -i - 1>$DIR/edc_drives.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect device information"
LogMessage "Failed to collect device information"
fi

LogMessage "Collecting media information"
mminfo -xc, -m -av 1>$DIR/edc_mediainfo.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect media information"
LogMessage "Failed to collect media information"
fi

LogMessage "Collecting NSR pool information"
echo print type:NSR pool 	| nsradmin -i - 1>$DIR/edc_storagepolicies.txt 2>&1
if [ $? -ne 0 ]; then
echo "Failed to collect storagepool information"
LogMessage "Failed to collect storage pool information"
fi


if [[ ! -f $DIR/edc_jobs_*.txt ]]; then
	echo "Removing intermediate files.."
	rm -rf $DIR/edc_jobs_*.txt
	echo "Done..."
fi

echo "Splitting  jobs based on groups"
SKIP_LINES=1
while read -r line ;do
	if [ $SKIP_LINES = 1 ]; then
		SKIP_LINES=0
	else
		GRPNAME=`echo $line | cut -f1 -d, | tr "[:upper:]" "[:lower:]"`
		echo $line >> "$DIR/edc_jobs_$GRPNAME.txt"
	fi
done < $DIR/edc_jobs.txt

echo "Tarring the output files"
LogMessage "Failed to tar the output files"

tmstamp=`date +%Y-%m-%d_%H-%M-%S`
tarfilename=edc_data_$tmstamp

tar -cf $DIR/$tarfilename.tar $DIR/
if [[ $? -ne 0 ]]; then 			# check return code passed to function
	echo "Failed to tar output files" 	# if rc > 0 then echo error msg and quit
	LogMessage "Failed to tar the output files"
else
	LogMessage "TAR succeeded"
	echo "*********** Please copy $DIR/$tarfilename.tar file. ***************"
fi




