#!/usr/bin/ksh
# The purpose of this script is to run NetBackup command line utiliies which 
# could be found in <NetBackup Installation directory>\netbackup\bin\admincmd
# directory in order to collect information about NetBackup Master server 
# configuration
# !!!!!!-THIS SCRIPT DOES NOT ALTER NETBACKUP CONFIGURATION IN ANY WAY-!!!!!!
#                    ~~~~~~~~~~~~~~

LogMessage()
{
	echo $1 >> $LOGDIR	
}

get_serverinfo()
{
    machinename=`hostname`

    #master server machine name
    echo -n "Enter NetBackup master server machine name (${machinename%%.*}): "
    read MASTERSERVERNAME
    if [[ "$MASTERSERVERNAME" = "" ]];then
        MASTERSERVERNAME=${machinename%%.*}
    fi

    MASTERSERVERNAME=${MASTERSERVERNAME## }
    MASTERSERVERNAME=${MASTERSERVERNAME%% }

    #master server host name
    echo -n  "Enter NetBackup master server host name    [$machinename]: "
    read MASTERSERVERHOST
    if [[ "$MASTERSERVERHOST" = "" ]];then
        MASTERSERVERHOST=$machinename
    fi
	
    #emm server host name
    echo -n "Enter NetBackup EMM server name [$machinename]: "
    read EMMSERVERNAME
    if [[ "$EMMSERVERNAME" = "" ]];then
    EMMSERVERNAME=$machinename
    fi

    MASTERSERVERHOST=${MASTERSERVERHOST## }
    MASTERSERVERHOST=${MASTERSERVERHOST%% }

    #master server version
    echo -n "Enter NetBackup major and minor version    [6.5]:"
    read NETBACKUPVERSION
    if [[ "$NETBACKUPVERSION" = "" ]];then
        NETBACKUPVERSION=6.5
    fi
    
    NETBACKUPVERSION=${NETBACKUPVERSION## }
    NETBACKUPVERSION=${NETBACKUPVERSION%% }

    NBVERSIONMAJOR=${NETBACKUPVERSION%%.*}
    NBVERSIONMAJOR=${NBVERSIONMAJOR## }
    NBVERSIONMAJOR=${NBVERSIONMAJOR%% }

    NBVERSIONMINOR=${NETBACKUPVERSION#*.}
    NBVERSIONMINOR=${NBVERSIONMINOR## }
    NBVERSIONMINOR=${NBVERSIONMINOR%% }

    #installation dir
    echo -n "Enter NetBackup installation directory     [/usr/openv]:"
    read INSTALLATIONDIR
    if [[ "$INSTALLATIONDIR" = "" ]];then
        INSTALLATIONDIR=/usr/openv
    fi
    
    INSTALLATIONDIR=${INSTALLATIONDIR## }
    INSTALLATIONDIR=${INSTALLATIONDIR%% }

    #binaries directory based on installation dir
    EXECBIN=$INSTALLATIONDIR/netbackup/bin
    EXECADMIN=$INSTALLATIONDIR/netbackup/bin/admincmd
    EXECDBACCESS=$INSTALLATIONDIR/db/bin
    EXECVOLMGR=$INSTALLATIONDIR/netbackup/volmgr/bin
    NETBACKUPLOGS=$INSTALLATIONDIR/netbackup/logs
}

echo_serverinfo()
{
    echo "Netbackup master server machine name : $MASTERSERVERNAME"
    echo "Netbackup master server machine host : $MASTERSERVERHOST"
    echo "NetBackup server version             : $NETBACKUPVERSION"
    echo ..........................................................................
    echo "NetBackup installation directory     : $INSTALLATIONDIR"
    echo "NetBackup binaries folder            : $EXECBIN"
    echo "NetBackup admin binaries folder      : $EXECADMIN"
    echo "NetBackup database binaries folder   : $EXECDBACCESS"
    echo "NetBackup volume manager folder      : $EXECVOLMGR"
    echo "NetBackup log files folder           : $NETBACKUPLOGS"
}

get_dbinfo()
{
    #database server name
    echo -n "Enter NetBackup database server name       ['nb_$EMMSERVERNAME']:"
    read DBACCESSSERVER    
    if [[ "$DBACCESSSERVER" = "" ]];then
        DBACCESSSERVER="nb_$EMMSERVERNAME"
    fi    
    
    DBACCESSSERVER=${DBACCESSSERVER## }
    DBACCESSSERVER=${DBACCESSSERVER%% }

    #database name

    echo -n "Enter NetBackup database name              ['NBDB']: "
    read DBACCESSNAME
    if [[ "$DBACCESSNAME" = "" ]];then
        DBACCESSNAME="NBDB"
    fi
    
    DBACCESSNAME=${DBACCESSNAME## }
    DBACCESSNAME=${DBACCESSNAME%% }

    #database directory based on installation dir
    DBACCESSINSTALLPATH=$INSTALLATIONDIR/db
    DBACCESSDATAPATH=$INSTALLATIONDIR/db/data

    #database user name

    echo -n "Enter NetBackup database user name         ['dba']: "
    read DBACCESSUSER
    if [[ "$DBACCESSUSER" = "" ]];then
        DBACCESSUSER=dba
    fi

    DBACCESSUSER=${DBACCESSUSER## }
    DBACCESSUSER=${DBACCESSUSER%% }

    #database password
    echo -n "Enter NetBackup database user password     ['nbusql']: "
    read DBACCESSPWD
    if [[ "$DBACCESSPWD" = "" ]];then
        DBACCESSPWD=nbusql
    fi
    
    DBACCESSPWD=${DBACCESSPWD## }
    DBACCESSPWD=${DBACCESSPWD%% }

    #database communication tcp port
    echo -n  "Enter database link port                   ['13785']: "
    read DBACCESSPORT    
    if [[ "$DBACCESSPORT" = "" ]];then
        DBACCESSPORT=13785
    fi
    
    DBACCESSPORT=${DBACCESSPORT## }
    DBACCESSPORT=${DBACCESSPORT%% }
}

get_destination()
{
    
    echo -n "Enter full path to a folder where files with gathered data will be stored [/tmp/nbdata]: "
    read DESTINATIONDIR
    
    if [[ "$DESTINATIONDIR" = "" ]];then
        DESTINATIONDIR=/tmp/nbdata
    fi

    DESTINATIONDIR=${DESTINATIONDIR## }
    DESTINATIONDIR=${DESTINATIONDIR%% }

}

echo_destination()
{
    echo ".........................................................................."
    echo "Gathered data will be saved at       : $DESTINATIONDIR"
    echo ".........................................................................."
}

echo_dbinfo()
{
    echo ".........................................................................."
    echo "NetBackup database server name       : $DBACCESSSERVER"
    echo "NetBackup database name              : $DBACCESSNAME"
    echo "NetBackup database install folder    : $DBACCESSINSTALLPATH"
    echo "NetBackup database data folder       : $DBACCESSDATAPATH"
    echo "NetBackup database user name         : $DBACCESSUSER"
    echo "NetBackup database password          : ********"
    echo "NetBackup database port              : $DBACCESSPORT"
}

get_confirmation()
{
    clear
    echo_serverinfo
    test $NBVERSIONMAJOR -gt 5 && echo_dbinfo
    echo_destination

    INFOREADY=0
    answer_local=""
    echo -n  "Continue? Y/N :"
    read answer_local
    case $answer_local in
        y)
            INFOREADY=2;;
        Y)
            INFOREADY=2;;
        n)
            INFOREADY=1;;
        N)
            INFOREADY=1;;
    esac
}

get_configuration()
{
    clear

    get_serverinfo
    test $NBVERSIONMAJOR -gt 5 && get_dbinfo
    get_destination
}

gather_data_jobs()
{
    # jobs bpconfig - all
    echo ".............................................................................."
    echo "Retrieving common jobs configuration : execute bpconfig"
	LogMessage "Retrieving common jobs configuration : execute bpconfig"
    $EXECADMIN/bpconfig  > $DESTINATIONDIR/jobs_config.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'jobs_config.txt' file."
    echo ""

    # jobs bpimagelist - all
    echo ".............................................................................."
    echo "Retrieving list of jobs. Step 1 : execute bpimagelist"
	LogMessage "Retrieving list of jobs. Step 1 : execute bpimagelist"
    $EXECADMIN/bpimagelist -hoursago 87600 -l > $DESTINATIONDIR/jobs_bpimage.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'jobs_bpimage.txt' file."
    echo ""

    #jobs bpdbjobs - all
    echo ".............................................................................."
    echo "Retrieving list of jobs. Step 2 : execute bpdbjobs"
	LogMessage "Retrieving list of jobs. Step 2 : execute bpdbjobs"
    $EXECADMIN/bpdbjobs -all_columns -noheader > $DESTINATIONDIR/jobs_bpdbjobs.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'jobs_bpdbjobs.txt' file."
    echo ""

    # jobs bperror - all
    echo ".............................................................................."
    echo "Retrieving list of jobs. Step 3 : execute bperror"
	LogMessage "Retrieving list of jobs. Step 3 : execute bperror"
    $EXECADMIN/bperror -s ALL -t BACKUP -l -hoursago 87600 > $DESTINATIONDIR/jobs_bperror.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'jobs_bperror.txt' file."
    echo ""
}

gather_data_media()
{
    echo ".............................................................................."
    echo "Retrieving list of magnetic libraries : execute bpstulist"
	LogMessage "Retrieving list of magnetic libraries : execute bpstulist"
    $EXECADMIN/bpstulist -lsa -l > $DESTINATIONDIR/maglibs_list.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'maglibs_list.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving magnetic libraries details : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/maglibsdetails.sql"
    test -f "$SQLFOLDER/maglibsdetails.sql" && QUERYTOEXECUTE="$SQLFOLDER/maglibsdetails.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/maglibs_details.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'maglibs_details.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving tape, optical libraries : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/robotslist.sql"
    test -f "$SQLFOLDER/robotslist.sql" && QUERYTOEXECUTE="$SQLFOLDER/robotslist.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/robots_list.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f "$QUERYFILENAME"
    echo "Command executed. Data stored in 'robots_list.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving libraries drives list : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/libdriveslist.sql"
    test -f "$SQLFOLDER/libdriveslist.sql" && QUERYTOEXECUTE="$SQLFOLDER/libdriveslist.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/libdrives_list.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'libdrives_list.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving standalone libraries list : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/standalonelibs.sql"
    test -f "$SQLFOLDER/standalonelibs.sql" && QUERYTOEXECUTE="$SQLFOLDER/standalonelibs.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/standalonelibs_list.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'standalonelibs_list.txt' file."
    echo ""
   
    echo ".............................................................................."
    echo "Retrieving media types list : execute nbemmcmd"
	LogMessage "Retrieving media types list : execute nbemmcmd"
    $EXECADMIN/nbemmcmd  -listmedia -allrecords > $DESTINATIONDIR/media_types.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'media_types.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving magnetic media list : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/medialistmag.sql"
    test -f "$SQLFOLDER/medialistmag.sql" && QUERYTOEXECUTE="$SQLFOLDER/medialistmag.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/media_maglist.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'media_maglist.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving tape, optical media list : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/medialistlib.sql"
    test -f "$SQLFOLDER/medialistlib.sql" && QUERYTOEXECUTE="$SQLFOLDER/medialistlib.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/media_liblist.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f "$QUERYFILENAME"
    echo "Command executed. Data stored in 'media_liblist.txt' file."
    echo ""

    echo ".............................................................................."
    echo "Retrieving unattended media list : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/medialistother.sql"
    test -f "$SQLFOLDER/medialistother.sql" && QUERYTOEXECUTE="$SQLFOLDER/medialistother.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/media_unalist.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'media_unalist.txt' file."
    echo ""
}

gather_data_storages_and_servers()
{
    # storage units - database access - 6.0 and up
    echo ".............................................................................."
    echo "Retrieving list of storage units : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/storageunits.sql"
    test -f "$SQLFOLDER/storageunits.sql" && QUERYTOEXECUTE="$SQLFOLDER/storageunits.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/storage_units.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f "$QUERYFILENAME"
    echo "Command executed. Data stored in 'storage_units.txt' file."
    echo ""
    # storage groups - database access - 6.0 and up
    echo ".............................................................................."
    echo "Retrieving list of storage unit groups : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/storagegroups.sql"
    test -f "$SQLFOLDER/storagegroups.sql" && QUERYTOEXECUTE="$SQLFOLDER/storagegroups.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/storage_groups.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f "$QUERYFILENAME"
    echo "Command executed. Data stored in 'storage_groups.txt' file."
    echo ""

    # additional servers - database access - 6.0 and up
    echo ".............................................................................."
    echo "Retrieving list of servers : $DBACCESSNAME database query"
    QUERYTOEXECUTE="$SQLFOLDERCOMMON/serverslist.sql"
    test -f "$SQLFOLDER/serverslist.sql" && QUERYTOEXECUTE="$SQLFOLDER/serverslist.sql"
    cp -f $QUERYTOEXECUTE $QUERYFILENAME
    echo "output to '$DESTINATIONDIR/servers_list_2.txt' format ascii" >> "$QUERYFILENAME"
    echo "go" >> "$QUERYFILENAME"
    $EXECDBACCESS/dbisqlc -q -c "ENG=$DBACCESSSERVER;DBN=$DBACCESSNAME;links=tcpip{port=$DBACCESSPORT};UID=$DBACCESSUSER;PWD=$DBACCESSPWD" $QUERYFILENAME
    rm -f  "$QUERYFILENAME"
    echo "Command executed. Data stored in 'servers_list_2.txt' file."
    echo ""
}

gather_lifecycles_and_servers()
{
    echo ".............................................................................."
    echo "Retrieving list of servers : execute nbdevquery"
	LogMessage "Retrieving list of servers : execute nbdevquery"
    $EXECADMIN/nbdevquery -liststs -l > $DESTINATIONDIR/servers_list_1.txt
    echo "Command executed. Data stored in 'servers_list_1.txt' file."
	LogMessage `echo $?`
    echo ""

    echo ".............................................................................."
    echo "Retrieving list of life cycle policies : execute nbstl"
	LogMessage "Retrieving list of life cycle policies : execute nbstl"
    $EXECADMIN/nbstl -L > $DESTINATIONDIR/life_cycles.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'life_cycles.txt' file."
    echo ""
}

gather_data()
{
    clear

    mkdir -p "$DESTINATIONDIR"
	LOGDIR=$DESTINATIONDIR/log.txt
	
    set CLOUDVERSIONFILE=CloudScriptVersion.txt
    head -1 edc_nbu.sh > $DESTINATIONDIR/$CLOUDVERSIONFILE

    echo ".............................................................................."
    echo "Generating configuration file"
    echo "$MASTERSERVERNAME"     >  $DESTINATIONDIR/configuration.txt
    echo "$MASTERSERVERHOST"     >> $DESTINATIONDIR/configuration.txt
    echo "$NETBACKUPVERSION"     >> $DESTINATIONDIR/configuration.txt
    echo "$INSTALLATIONDIR"      >> $DESTINATIONDIR/configuration.txt
    echo "$EXECBIN"              >> $DESTINATIONDIR/configuration.txt
    echo "$EXECADMIN"            >> $DESTINATIONDIR/configuration.txt
    echo "$EXECVOLMGR"           >> $DESTINATIONDIR/configuration.txt
    echo "$DBACCESSNAME"         >> $DESTINATIONDIR/configuration.txt
    echo "$EXECDBACCESS"         >> $DESTINATIONDIR/configuration.txt
    echo "$DBACCESSINSTALLPATH"  >> $DESTINATIONDIR/configuration.txt
    echo "$DBACCESSDATAPATH"     >> $DESTINATIONDIR/configuration.txt
    echo "$DBACCESSSERVER"       >> $DESTINATIONDIR/configuration.txt
    echo "$DBACCESSPORT"         >> $DESTINATIONDIR/configuration.txt
    echo "$NETBACKUPLOGS"        >> $DESTINATIONDIR/configuration.txt
    echo "$EMMSERVERNAME"        >> $DESTINATIONDIR/configuration.txt

    echo "Configuration data stored in 'configuration.txt' file."
	LogMessage "Configuration data stored in 'configuration.txt' file."

    #retentions - all
    echo ".............................................................................."
    echo "Retrieving list of retention levels : execute bpretlevel"
	LogMessage "Retrieving list of retention levels : execute bpretlevel"
    $EXECADMIN/bpretlevel -l > $DESTINATIONDIR/retention_levels.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'retention_levels.txt' file."
    echo ""

    #policies - all
    echo ".............................................................................."
    echo "Retrieving list of policies : execute bppllist"
	LogMessage "Retrieving list of policies : execute bppllist"
    $EXECADMIN/bppllist -allpolicies > $DESTINATIONDIR/policies_list.txt
	LogMessage `echo $?`
    echo "Command executed. Data stored in 'policies_list.txt' file."
    echo ""

    #storage units
    test $NBVERSIONMAJOR -gt 5 && gather_data_storages_and_servers

    #servers and life cycle policies
    test $NBVERSIONMAJOR -gt 6 && gather_lifecycles_and_servers  ||
    test $NBVERSIONMAJOR -gt 5 && test  $NBVERSIONMINOR -gt 4 && gather_lifecycles_and_servers

    #jobs
    gather_data_jobs

    #media
    test $NBVERSIONMAJOR -gt 5 && gather_data_media

    clear
    echo "Data gathering process has finished"
	echo "Running tar command to bundle the output files"
	LogMessage "Running tar command to bundle the output files"

	tmstamp=`date +%Y-%m-%d_%H-%M-%S`
	tarfilename=edc_data_$tmstamp

	tar -cf $DESTINATIONDIR/$tarfilename.tar $DESTINATIONDIR/
	if [ $? -ne 0 ]; then
		LogMessage "Failed to bundle the output files - TAR failed"
		echo "Failed to bundle the output files - TAR failed"
	else
		LogMessage "TAR command successful"
		echo "**********************PLEAE COPY $DESTINATIONDIR/$tarfilename.tar******************************"
	fi
}

# Continue
INFOREADY=1

while [ $INFOREADY -eq 1 ]
do
    NETBACKUPVERSION=""
    NBVERSIONMAJOR=""
    NBVERSIONMINOR=""
    MASTERSERVERNAME=""
    EMMSERVERNAME=""
    MASTERSERVERHOST=""
    INSTALLATIONDIR=""
    EXECBIN=""
    EXECADMIN=""
    EXECDBACCESS=""
    EXECVOLMGR=""
    NETBACKUPLOGS=""
    # database related variables
    DBACCESSSERVER=""
    DBACCESSNAME=""
    DBACCESSUSER=""
    DBACCESSPWD=""
    DBACCESSPORT=""
    DBACCESSDATAPATH=""
    DBACCESSINSTALLPATH=""

    # Destination directory
    DESTINATIONDIR=""

    # Continue
    INFOREADY=0
	
	
	EULA=eula.txt

	if [[ ! -f $EULA ]]; then
		echo "The end user license file does not exist. Please make sure that you copy the file $EULA"
		exit 1
	fi

	more $EULA
	echo -n "Do you accept the terms and conditions(Y/N)?"
	read eula_agreement

	if [[ "$eula_agreement" != "Y" && "$eula_agreement" != "y" ]]; then
		echo "Exiting the program as the EULA was not accepted"
		exit 1
	fi

    get_configuration
    while [ $INFOREADY -eq 0 ]
    do
        get_confirmation
    done

done


# Absolute path this script is in. /home/user/bin
THISFILE="$(whence ${0})"
SCRIPTPATH="${THISFILE%/*}"

SQLFOLDERCOMMON="$SCRIPTPATH/SQL"
SQLFOLDER="$SQLFOLDERCOMMON/$NBVERSIONMAJOR$NBVERSIONMINOR"
QUERYTOEXECUTE=""
QUERYFILENAME="$DESTINATIONDIR/query.in"

# netbackup libraries
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$INSTALLATIONDIR/db/lib;
export LD_LIBRARY_PATH;

gather_data


