SELECT  SU.StorageUnitName,  
        SU.ConcurrentJobs,   
        SU.MaxFragmentSize,  
        SU.MaxMultiplexing,  

        ISNULL((CASE WHEN StorageUnitType = 0 THEN (SELECT DISTINCT TOP 1 M.MachinePrimaryName 
                                                    FROM   EMM_MAIN.EMM_StorageUnit SUI 
                                                           INNER JOIN EMM_MAIN.EMM_DiskGroup_StorageUnit DG ON SUI.StorageUnitKey = DG.StorageUnitKey 
                                                           INNER JOIN EMM_MAIN.EMM_DiskVolume            DV ON DV.DiskGroupKey    = DG.DiskGroupKey   
                                                           INNER JOIN EMM_MAIN.EMM_DiskVolumeMountPoint  MP ON MP.DiskVolumeKey   = DV.DiskVolumeKey  
                                                           INNER JOIN EMM_MAIN.EMM_Machine               M  ON M.MachineKey       = MP.MachineKey     
                                                    WHERE  SUI.StorageUnitKey = SU.StorageUnitKey 
                                                    ORDER  BY M.MachinePrimaryName ASC) 
                                              ELSE  M.MachinePrimaryName 
                END), 
               (SELECT MachinePrimaryName FROM EMM_MAIN.EMM_Machine WHERE ParentKey = 0 AND MachineFlags <> 0)) AS MachineName,  

        ISNULL((CASE WHEN StorageUnitType = 0 THEN (SELECT  DISTINCT TOP 1 M.FQMachineName 
                                                    FROM    EMM_MAIN.EMM_StorageUnit SUI 
                                                            INNER JOIN EMM_MAIN.EMM_DiskGroup_StorageUnit DG ON SUI.StorageUnitKey = DG.StorageUnitKey 
                                                            INNER JOIN EMM_MAIN.EMM_DiskVolume            DV ON DV.DiskGroupKey    = DG.DiskGroupKey   
                                                            INNER JOIN EMM_MAIN.EMM_DiskVolumeMountPoint  MP ON MP.DiskVolumeKey   = DV.DiskVolumeKey  
                                                            INNER JOIN EMM_MAIN.EMM_Machine               M  ON M.MachineKey       = MP.MachineKey     
                                                    WHERE   SUI.StorageUnitKey = SU.StorageUnitKey 
                                                    ORDER   BY M.FQMachineName ASC)  
                                              ELSE M.FQMachineName 
                     END), 
               (SELECT FQMachineName FROM EMM_MAIN.EMM_Machine WHERE ParentKey = 0 AND MachineFlags <> 0)) AS MachineFQName, 

        CASE WHEN SU.StorageUnitType = 0 THEN SU.StorageUnitName ELSE ( CASE WHEN (SU.RobotType <> 0) THEN ( SELECT  DISTINCT TOP 1 D.DeviceName 
                                                                                                             FROM    EMM_MAIN.EMM_Device D 
                                                                                                             WHERE       D.LibraryNumber = SU.RobotNumber 
                                                                                                                     AND D.DriveParentKey = 0 
                                                                                                             ORDER BY D.DeviceName ) 
                                                                                                      ELSE ( SELECT  DISTINCT TOP 1 Dev.DeviceName 
                                                                                                             FROM    EMM_MAIN.EMM_Device Dev 
                                                                                                                     INNER JOIN EMM_MAIN.EMM_DriveType_Density_MediaTyp DTDM ON DTDM.DriveTypeName = Dev.DeviceTypeName 
                                                                                                                     INNER JOIN EMM_MAIN.EMM_Density D ON D.DensityName = DTDM.DensityName 
                                                                                                             WHERE   D.LegacyDensityType = SU.LegacyDensityType 
                                                                                                             ORDER BY Dev.DeviceName) 
                                                                                                      END ) 
        END AS LibraryName, 
        SU.StorageUnitType, 
        0 AS StubColumn     
FROM    EMM_MAIN.EMM_StorageUnit SU 
        LEFT JOIN EMM_MAIN.EMM_Machine M ON M.MachineKey = SU.MediaServerKey;  
