SELECT  M.MediaKey,         
        M.DriveKey,         
        M.MediaTypeName,    
        M.Barcode,          
        M.ManufacturerName, 
        M.SerialNumber,     
        M.SlotNumber,       
        (SELECT D.DeviceName FROM EMM_MAIN.EMM_Device D WHERE D.DeviceKey = M.DriveKey) as LocationName, 
        M.MediaId,          
        'Unknown' AS DeviceName, 
        (CASE WHEN LG.ShortLibraryGroupName = 'ODL' THEN 2 ELSE 1 END ) AS LibType,             
        datediff(second, '1970-01-01 00:00:00.000', M.LastWriteDateTime) AS LastWriteTime,      
        datediff(second, '1970-01-01 00:00:00.000', M.LastRestoreDateTime) AS LastReadTime,     
        CONVERT (BIGINT,  M.TotalWriteKBytes * 1024) AS TotalOccupied,                          
        M.TotalMounts,          
        M.MediaGroupName,       
		M.MediaRunTimeStatus,   
		(CASE M.MediaRunTimeStatus WHEN 1 THEN 'Frozen Media' WHEN 2 THEN 'Suspended Media' ELSE '' END) 
FROM    EMM_MAIN.EMM_Media M    
        INNER JOIN EMM_MAIN.EMM_MediaGroup MG ON MG.MediaGroupName = M.MediaGroupName                    
        INNER JOIN EMM_MAIN.EMM_LibraryGroup LG ON LG.LibraryGroupName = MG.LibraryGroupName             
WHERE  MG.LibraryNumber = -1

GO 

