SELECT  SU.StorageUnitName, 
        SU.ConcurrentJobs,  
        SU.MaxFragmentSize, 
        SU.MaxMultiplexing, 
        ISNULL( SU.MediaServer, ISNULL((SELECT TOP 1 MachinePrimaryName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = SU.MasterServerKey ORDER BY MachinePrimaryName ASC), 
                                       (SELECT TOP 1 MachinePrimaryName FROM EMM_MAIN.EMM_Machine WHERE ParentKey = 0 AND MachineFlags <> 0 ORDER BY MachinePrimaryName ASC)) 
              ) AS MachineName, 
        ISNULL( (SELECT FQMachineName FROM EMM_MAIN.EMM_Machine WHERE MachinePrimaryName = SU.MediaServer AND MachineKey = SU.MasterServerKey), 
                 ISNULL( (SELECT TOP 1 FQMachineName FROM EMM_MAIN.EMM_Machine WHERE MachineKey = SU.MasterServerKey ORDER BY FQMachineName ASC), 
                         (SELECT TOP 1 FQMachineName FROM EMM_MAIN.EMM_Machine WHERE ParentKey = 0 AND MachineFlags <> 0 ORDER BY FQMachineName ASC) ) 
              ) AS MachineFQName, 
        CASE WHEN SU.StorageUnitType = 0 THEN SU.StorageUnitName ELSE ( CASE WHEN (SU.RobotType <> 0) THEN ( SELECT  DISTINCT TOP 1 D.DeviceName 
                                                                                                             FROM    EMM_MAIN.EMM_Device D 
                                                                                                             WHERE       D.LibraryNumber = SU.RobotNumber 
                                                                                                                     AND D.DriveParentKey = 0 
                                                                                                             ORDER   BY D.DeviceName ASC) 
                                                                                                      ELSE ( SELECT  DISTINCT TOP 1 Dev.DeviceName 
                                                                                                             FROM    EMM_MAIN.EMM_Device Dev 
                                                                                                                     INNER JOIN EMM_MAIN.EMM_DriveType_Density_MediaTyp DTDM ON DTDM.DriveTypeName = Dev.DeviceTypeName 
                                                                                                                     INNER JOIN EMM_MAIN.EMM_Density D ON D.DensityName = DTDM.DensityName 
                                                                                                             WHERE   D.LegacyDensityType = SU.Density 
                                                                                                             ORDER   BY Dev.DeviceName ASC) 
                                                                                                      END ) 
        END AS LibraryName, 
        SU.StorageUnitType, 
        0 AS StubColumn     
FROM    EMM_MAIN.EMM_StorageUnit SU

GO