/*
 * Decompiled with CFR 0.152.
 */
package webserver;

import com.google.inject.servlet.GuiceFilter;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import webserver.InjectedWebListener;

public class UtilServer {
    private static final Logger logger = Logger.getLogger((String)UtilServer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)Paths.get(System.getProperty("cvutil.config.file"), "cvhadooplog4j.properties").toAbsolutePath().toString());
        int port = 9999;
        String host = "localhost";
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length == 2) {
            host = args[1];
        }
        logger.info((Object)"Starting the server");
        InetSocketAddress addr = new InetSocketAddress(host, port);
        Server jettyServer = new Server(addr);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)jettyServer, "/", 1);
        context.addEventListener((EventListener)((Object)new InjectedWebListener()));
        context.addFilter(GuiceFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        context.addServlet(DefaultServlet.class, "/");
        logger.info((Object)"Successfully started");
        try {
            jettyServer.start();
            jettyServer.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

