/*
 * Decompiled with CFR 0.152.
 */
package webserver;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import configuration.IConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Singleton;
import jaxrs.GenericExceptionHandler;
import jaxrs.GsonProvider;
import org.apache.log4j.Logger;
import resources.hadooputil;

public class InjectedWebListener
extends GuiceServletContextListener {
    protected static final Logger logger = Logger.getLogger(InjectedWebListener.class);

    protected Injector getInjector() {
        logger.info((Object)" Starting injection process");
        ArrayList moduleList = Lists.newArrayList();
        moduleList.add(new JaxServletModule());
        Injector injector = Guice.createInjector((Iterable)moduleList);
        try {
            injector.getInstance(IConfiguration.class);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return injector;
    }

    public static class JaxServletModule
    extends ServletModule {
        protected void configureServlets() {
            this.bind(hadooputil.class);
            this.bind(GsonProvider.class).in(Singleton.class);
            this.bind(GenericExceptionHandler.class).in(Singleton.class);
            logger.info((Object)" Starting Configuring servelets");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("com.sun.jersey.spi.container.ResourceFilters", "com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory");
            params.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
            params.put("com.sun.jersey.config.property.packages", "resources");
            this.serve("/REST/*", new String[0]).with(GuiceContainer.class, params);
        }
    }
}

