/*
 * Decompiled with CFR 0.152.
 */
package util;

public final class StackTraceUtil {
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";

    public static String getStackTrace(Throwable aThrowable) {
        StackTraceElement[] els = aThrowable.getStackTrace();
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append(aThrowable);
        sbuilder.append(NEWLINE);
        sbuilder.append(aThrowable.getLocalizedMessage());
        sbuilder.append(NEWLINE);
        if (els != null && els.length > 0) {
            for (StackTraceElement stackTraceElement : els) {
                sbuilder.append(TAB);
                sbuilder.append(stackTraceElement.toString());
                sbuilder.append(NEWLINE);
            }
        }
        return sbuilder.toString();
    }

    public static String getCompleteErrorDetail(Throwable aThrowable) {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Exception Type : ");
        sbuilder.append(aThrowable.getClass().getName());
        sbuilder.append(NEWLINE);
        sbuilder.append("Error : ");
        sbuilder.append(aThrowable.getMessage());
        sbuilder.append(NEWLINE);
        sbuilder.append(StackTraceUtil.getStackTrace(aThrowable));
        return sbuilder.toString();
    }

    public static String getBriefErrorDetail(Throwable aThrowable) {
        return StackTraceUtil.getBriefErrorDetail(aThrowable, 5);
    }

    public static String getBriefErrorDetail(Throwable aThrowable, int stackTraceLines) {
        StringBuilder sbuilder = new StringBuilder();
        StackTraceElement[] elements = aThrowable.getStackTrace();
        sbuilder.append("Exception Type : ");
        sbuilder.append(aThrowable.getClass().getName());
        sbuilder.append(NEWLINE);
        sbuilder.append("Error : ");
        sbuilder.append(aThrowable.getMessage());
        sbuilder.append(NEWLINE);
        if (elements != null && elements.length > 0) {
            if (stackTraceLines <= 0 || stackTraceLines > elements.length) {
                stackTraceLines = elements.length;
            }
            for (int i = 0; i < stackTraceLines; ++i) {
                sbuilder.append(TAB);
                sbuilder.append(elements[i].toString());
                sbuilder.append(NEWLINE);
            }
        }
        return sbuilder.toString();
    }
}

