/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public abstract class RetryableCallable<T>
implements Callable<T> {
    private static final Logger logger = Logger.getLogger(RetryableCallable.class);
    public static final int DEFAULT_NUMBER_OF_RETRIES = 15;
    public static final long DEFAULT_WAIT_TIME = 100L;
    private int retrys;
    private long waitTime;

    public RetryableCallable() {
        this(15, 100L);
    }

    public RetryableCallable(int retrys, long waitTime) {
        this.set(retrys, waitTime);
    }

    public void set(int retrys, long waitTime) {
        this.retrys = retrys;
        this.waitTime = waitTime;
    }

    public abstract T retriableCall() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        int retry = 0;
        int logCounter = 0;
        while (true) {
            try {
                T t = this.retriableCall();
                return t;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (++retry == this.retrys) {
                    throw e;
                }
                logger.error((Object)String.format("Retry #%d for: %s", retry, e.getMessage()));
                if (++logCounter == 1) {
                    logger.error((Object)("Exception --> " + ExceptionUtils.getFullStackTrace((Throwable)e)));
                }
                Thread.sleep(this.waitTime);
                continue;
            }
            finally {
                this.forEachExecution();
                continue;
            }
            break;
        }
    }

    public void forEachExecution() {
    }
}

