/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import util.StackTraceUtil;

public final class KerberosUtil {
    private static Logger log = Logger.getLogger(KerberosUtil.class);
    private static InetAddress ip;

    public static Boolean Login(String[] principals, String keyTabLocation, Configuration configuration) throws Exception {
        for (String principal : principals) {
            try {
                if (!KerberosUtil.Login(principal, keyTabLocation, configuration).booleanValue()) continue;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new Exception("All attempts failed for user list ");
    }

    public static Boolean Login(String principal, String keyTabLocation, Configuration configuration) throws Exception {
        String line;
        String strPrincipalWithHostName;
        UserGroupInformation.setConfiguration((Configuration)configuration);
        String strPrincipalNoHost = principal.replaceFirst("_HOST", "");
        if (KerberosUtil.Login(strPrincipalNoHost, keyTabLocation).booleanValue()) {
            return true;
        }
        if (ip == null) {
            ip = InetAddress.getLocalHost();
            log.info((Object)("Hostname: " + ip.getHostName()));
        }
        if (KerberosUtil.Login(strPrincipalWithHostName = strPrincipalNoHost + "/" + ip.getHostName(), keyTabLocation).booleanValue()) {
            return true;
        }
        String command = "klist -k \"" + keyTabLocation + "\" | grep -v \"" + keyTabLocation + "\" | grep -w " + strPrincipalNoHost + " | awk '{print $2}' | sort | uniq";
        log.info((Object)("Running command: " + command));
        Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", command});
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (!KerberosUtil.Login(line = line.replace("\n", ""), keyTabLocation).booleanValue()) continue;
            return true;
        }
        reader.close();
        throw new Exception("All attempts failed for user: " + principal);
    }

    public static Boolean Login(String principal, String keyTabLocation) {
        try {
            log.info((Object)("Logging in as: " + principal));
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keyTabLocation);
            return true;
        }
        catch (Exception e) {
            log.info((Object)("Failed for principal: " + principal));
            log.info((Object)StackTraceUtil.getStackTrace(e));
            return false;
        }
    }
}

