/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.concurrent.CancellationException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import util.RetryableCallable;
import util.ThreadSleeper;

public abstract class BoundedExponentialRetryCallable<T>
extends RetryableCallable<T> {
    public static final long MAX_SLEEP = 10000L;
    public static final long MIN_SLEEP = 1000L;
    public static final int MAX_RETRIES = 10;
    private static final Logger logger = Logger.getLogger(BoundedExponentialRetryCallable.class);
    private long max;
    private long min;
    private int maxRetries;
    private final ThreadSleeper sleeper = new ThreadSleeper();

    public BoundedExponentialRetryCallable() {
        this.max = 10000L;
        this.min = 1000L;
        this.maxRetries = 10;
    }

    public BoundedExponentialRetryCallable(long minSleep, long maxSleep, int maxNumRetries) {
        this.max = maxSleep;
        this.min = minSleep;
        this.maxRetries = maxNumRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        long delay = this.min;
        int retry = 0;
        int logCounter = 0;
        while (true) {
            try {
                Object t = this.retriableCall();
                return t;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (delay < this.max && ++retry <= this.maxRetries) {
                    delay *= 2L;
                    logger.error((Object)String.format("Retry #%d for: %s", retry, e.getMessage()));
                    if (++logCounter == 1) {
                        logger.info((Object)("Exception --> " + ExceptionUtils.getFullStackTrace((Throwable)e)));
                    }
                    this.sleeper.sleep(delay);
                    continue;
                }
                if (delay >= this.max && retry <= this.maxRetries) {
                    logger.error((Object)String.format("Retry #%d for: %s", retry, ExceptionUtils.getFullStackTrace((Throwable)e)));
                    this.sleeper.sleep(this.max);
                    continue;
                }
                throw e;
            }
            finally {
                this.forEachExecution();
                continue;
            }
            break;
        }
    }
}

