/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.github.gbraccialli.hdfs.HDFSConfigUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class hdfsWritetest {
    private static Logger log = Logger.getLogger(hdfsWritetest.class);

    public static void main(String[] args) throws Exception {
        String confDir = "/etc/hadoop/conf";
        String path = "/";
        int maxLevelThreshold = -1;
        long minSizeThreshold = -1L;
        boolean showFiles = false;
        boolean verbose = false;
        String doAs = "hdfs";
        Object excludeList = null;
        boolean size = false;
        int offset = 0;
        String writeChar = null;
        for (String arg : args) {
            if (arg.startsWith("--confDir=")) {
                confDir = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--path=")) {
                path = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--maxLevelThreshold=")) {
                maxLevelThreshold = Integer.parseInt(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--minSizeThreshold=")) {
                minSizeThreshold = Long.parseLong(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--showFiles=")) {
                showFiles = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--verbose=")) {
                verbose = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--doAs=")) {
                doAs = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--offset=")) {
                offset = Integer.parseInt(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--writeChar=")) {
                writeChar = arg.split("=")[1];
                continue;
            }
            log.info((Object)("Argumment not in list of valid arguments, it will be ignored:" + arg));
        }
        System.setProperty("HADOOP_USER_NAME", doAs);
        FileSystem hdfs = HDFSConfigUtils.loadConfigsAndGetFileSystem(confDir, doAs);
        Path hdfsPath = new Path(path);
        FSDataOutputStream os = !hdfs.exists(hdfsPath) ? hdfs.create(hdfsPath) : hdfs.append(hdfsPath);
        byte[] buf = new byte[0x8000000];
        buf = StringUtils.repeat(writeChar, (int)0x8000000).getBytes();
        os.write(buf);
    }
}

