/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.github.gbraccialli.hdfs.HDFSConfigUtils;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;
import tests.hdfsWritetest;

public class concatFiles {
    private static Logger log = Logger.getLogger(hdfsWritetest.class);

    public static void main(String[] args) throws Exception {
        String confDir = "/etc/hadoop/conf";
        String path = null;
        int maxLevelThreshold = -1;
        long minSizeThreshold = -1L;
        boolean showFiles = false;
        boolean verbose = false;
        String doAs = "hdfs";
        boolean size = false;
        String target = null;
        String writeChar = null;
        for (String string : args) {
            if (string.startsWith("--confDir=")) {
                confDir = string.split("=")[1];
                continue;
            }
            if (string.startsWith("--path=")) {
                path = string.split("=")[1];
                continue;
            }
            if (string.startsWith("--maxLevelThreshold=")) {
                maxLevelThreshold = Integer.parseInt(string.split("=")[1]);
                continue;
            }
            if (string.startsWith("--minSizeThreshold=")) {
                minSizeThreshold = Long.parseLong(string.split("=")[1]);
                continue;
            }
            if (string.startsWith("--showFiles=")) {
                showFiles = Boolean.parseBoolean(string.split("=")[1]);
                continue;
            }
            if (string.startsWith("--verbose=")) {
                verbose = Boolean.parseBoolean(string.split("=")[1]);
                continue;
            }
            if (string.startsWith("--doAs=")) {
                doAs = string.split("=")[1];
                continue;
            }
            if (string.startsWith("--target=")) {
                target = string.split("=")[1];
                continue;
            }
            if (string.startsWith("--writeChar=")) {
                writeChar = string.split("=")[1];
                continue;
            }
            log.info((Object)("Argumment not in list of valid arguments, it will be ignored:" + string));
        }
        System.setProperty("HADOOP_USER_NAME", doAs);
        DistributedFileSystem hdfs = (DistributedFileSystem)HDFSConfigUtils.loadConfigsAndGetFileSystem(confDir, doAs);
        if (path != null) {
            try {
                Path[] sourcePaths = new Path[path.split(",").length];
                int Index = 0;
                for (String source : path.split(",")) {
                    sourcePaths[Index++] = new Path(source);
                }
                hdfs.concat(new Path(target), sourcePaths);
                System.err.println("Permission exception expected");
            }
            catch (IOException ie) {
                System.out.println("Got expected exception for permissions:" + ie.getLocalizedMessage());
            }
        } else {
            try {
                Path TargetFile = new Path(target);
                System.out.println("Target file " + TargetFile.getName());
                if (!hdfs.exists(TargetFile)) {
                    System.out.println("File exists");
                    System.out.println(hdfs.createNewFile(TargetFile));
                }
                Path parentdir = TargetFile.getParent();
                TreeMap<Integer, Path> treeMap = new TreeMap<Integer, Path>();
                for (FileStatus fs : hdfs.listStatus(parentdir)) {
                    if (!fs.isFile() || !fs.getPath().getName().contains(TargetFile.getName() + ".cvpart.")) continue;
                    System.out.println(fs.getPath().getName());
                    String[] SplitPath = fs.getPath().getName().split("\\.");
                    treeMap.put(Integer.valueOf(SplitPath[SplitPath.length - 1]), fs.getPath());
                }
                Path[] sourcePaths = new Path[treeMap.size()];
                sourcePaths = treeMap.values().toArray(new Path[treeMap.size()]);
                hdfs.concat(TargetFile, sourcePaths);
            }
            catch (IOException ie) {
                System.out.println("Got expected exception: " + ie.getLocalizedMessage());
            }
        }
    }
}

