/*
 * Decompiled with CFR 0.152.
 */
package resources;

import com.github.gbraccialli.hdfs.DirectoryContentsUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import configuration.IConfiguration;
import inputs.HDFSInput;
import inputs.HadoopConcatInput;
import inputs.HdfsAclInput;
import inputs.HdfsDeleteInput;
import inputs.HelloWorld;
import inputs.PathInfo;
import inputs.rackpath;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/hadoop")
public class hadooputil {
    private static final Logger logger = Logger.getLogger(hadooputil.class);
    @Inject
    HelloWorld helloWord;
    private IConfiguration config;

    @Inject
    public hadooputil(IConfiguration config) {
        this.config = config;
    }

    @GET
    @Path(value="/hello.json")
    @Produces(value={"application/json"})
    public Data getJsonMessage() throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        return new Data(this.helloWord.say());
    }

    @GET
    @Path(value="/hdfs2")
    @Produces(value={"application/json"})
    public String getJSON(@PathParam(value="username") String path) throws Exception {
        Gson gson = new GsonBuilder().create();
        Object hdfsDirUtil = null;
        return gson.toJson((Object)DirectoryContentsUtils.GSONGet(new HDFSInput()));
    }

    @POST
    @Path(value="/hdfs")
    @Consumes(value={"application/json"})
    public Response getJSON(HDFSInput input) throws Exception {
        Gson gson = new GsonBuilder().create();
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        PathInfo pathInfo = new PathInfo();
        pathInfo = DirectoryContentsUtils.GSONGet(input);
        return Response.ok((Object)gson.toJson((Object)pathInfo), (String)"application/json").build();
    }

    @POST
    @Path(value="/getrack")
    @Consumes(value={"application/json"})
    public String getRack(rackpath path) throws Exception {
        Gson gson = new GsonBuilder().create();
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        return hdfsDirUtil.getRack(path);
    }

    @GET
    @Path(value="/getrack")
    public String getRackDetails(@QueryParam(value="path") String path) throws Exception {
        Gson gson = new GsonBuilder().create();
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        return hdfsDirUtil.getRack(path);
    }

    @POST
    @Path(value="/concat")
    public Response concatFile(HadoopConcatInput input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        hdfsDirUtil.ConcatFiles(input);
        return Response.ok().build();
    }

    @POST
    @Path(value="/setattrs")
    public Response setAttrs(PathInfo input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        hdfsDirUtil.setAttrs(input);
        return Response.ok().build();
    }

    @POST
    @Path(value="/deletefiles")
    public Response deleteFiles(HdfsDeleteInput input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        logger.info((Object)"Delete api called");
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        hdfsDirUtil.deleteFiles(input);
        return Response.ok().build();
    }

    @POST
    @Path(value="/getacl")
    public String getAcl(HdfsAclInput input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        return hdfsDirUtil.getAcl(input);
    }

    @POST
    @Path(value="/setacl")
    public Response setAcl(HdfsAclInput input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        hdfsDirUtil.setAcl(input);
        return Response.ok().build();
    }

    public static class Data {
        private String text;

        public Data(String data) {
            this.text = data;
        }

        public String getData() {
            return this.text;
        }
    }
}

