/*
 * Decompiled with CFR 0.152.
 */
package resources;

import com.github.gbraccialli.hdfs.DirectoryContentsUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import configuration.IConfiguration;
import hbaseLibrary.hbaseUtil;
import inputs.HbaseBackupInput;
import inputs.HbaseIncrInput;
import inputs.HdfsDeleteInput;
import inputs.RestoreReq;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/hbase")
public class HbaseResource {
    private IConfiguration config;

    @Inject
    public HbaseResource(IConfiguration config) {
        this.config = config;
    }

    @GET
    @Path(value="/getdb")
    public Response getDbList() throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson((Object)util.loaddbs()), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getRegion")
    public Response getRegion() throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson(hbaseUtil.loaddbregions()), (String)"application/json").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/dobackup")
    public Response doBackup(HbaseBackupInput bkpInput) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson(util.doBackup(bkpInput)), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getstatus")
    public Response getStatus(@QueryParam(value="backupid") String backupID) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson((Object)hbaseUtil.getInfo(backupID)), (String)"application/json").build();
    }

    @GET
    @Path(value="/getprogress")
    public Response getProgress(@QueryParam(value="backupid") String backupID) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)hbaseUtil.getProgress(backupID)).build();
    }

    @GET
    @Path(value="/getdatadirsize")
    public Response getDataDirSize() throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson((Object)hbaseUtil.getDataDirSize()), (String)"application/json").build();
    }

    @GET
    @Path(value="/getlogdirsize")
    public Response getLogDirSize() throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)gson.toJson((Object)hbaseUtil.getLogDirSize()), (String)"application/json").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/dorestores")
    public Response doRestores(RestoreReq rstInput) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        util.doRestore(rstInput);
        return Response.ok().build();
    }

    @POST
    @Path(value="/snapshot")
    public Response doSnap(HbaseBackupInput input) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)hbaseUtil.snapshot(input), (String)"application/json").build();
    }

    @GET
    @Path(value="/getdatadir")
    public Response getDataDir() throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)hbaseUtil.getDataDir()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/dosnaprestores")
    public Response doRestore(RestoreReq rstInput) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        hbaseUtil.restoreSnap(rstInput);
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/doincrsnaprestores")
    public Response doIncrRestore(RestoreReq rstInput) throws Exception {
        Gson gson = new GsonBuilder().create();
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        hbaseUtil.restoreIncr(rstInput);
        return Response.ok().build();
    }

    @GET
    @Path(value="/dosnaprestores")
    public Response doSnapRestores(String snapID) throws Exception {
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        util.deleteSnap(snapID);
        return Response.ok().build();
    }

    @GET
    @Path(value="/flushAll")
    public Response flushAll() throws Exception {
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        util.flushAllTables();
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/walplayer")
    public Response WalPlayer(HbaseIncrInput rstInput) throws Exception {
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        return Response.ok((Object)hbaseUtil.WalPlayer(rstInput), (String)"application/json").build();
    }

    @POST
    @Path(value="/deletefiles")
    public Response deleteFiles(HdfsDeleteInput input) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(this.config);
        hdfsDirUtil.deleteFiles(input);
        return Response.ok().build();
    }

    @GET
    @Path(value="/deleteSnap")
    public Response deleteSnap(@QueryParam(value="snapID") String snapID) throws Exception {
        hbaseUtil util = null;
        util = hbaseUtil.instance(this.config);
        util.deleteSnap(snapID);
        return Response.ok().build();
    }
}

