/*
 * Decompiled with CFR 0.152.
 */
package jaxrs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GsonProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static final String PRETTY_PRINT = "pretty-print";
    private final Gson gson;
    private final Gson prettyGson;
    @Context
    private UriInfo ui;

    public GsonProvider() {
        GsonBuilder builder = new GsonBuilder().serializeNulls().enableComplexMapKeySerialization();
        this.gson = builder.create();
        this.prettyGson = builder.setPrettyPrinting().create();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try (InputStreamReader reader = new InputStreamReader(entityStream, "UTF-8");){
            Object object = this.gson.fromJson((Reader)reader, type);
            return (T)object;
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (PrintWriter printWriter = new PrintWriter(entityStream);){
            String json = this.ui.getQueryParameters().containsKey((Object)PRETTY_PRINT) ? this.prettyGson.toJson(t) : this.gson.toJson(t);
            printWriter.write(json);
            printWriter.flush();
        }
    }
}

