/*
 * Decompiled with CFR 0.152.
 */
package jaxrs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.log4j.Logger;
import output.ErrorFormat;
import util.StackTraceUtil;

@Provider
public class GenericExceptionHandler
implements ExceptionMapper<Throwable> {
    private static Logger logger = Logger.getLogger(GenericExceptionHandler.class);

    public GenericExceptionHandler() {
        System.out.println("Mapper created");
    }

    public Response toResponse(Throwable exception) {
        Gson gson = new GsonBuilder().create();
        ErrorFormat error = new ErrorFormat();
        error.setIsError(true);
        error.setError(exception.getMessage());
        error.setOther(exception.getLocalizedMessage());
        logger.info((Object)exception.getMessage());
        logger.info((Object)StackTraceUtil.getStackTrace(exception));
        exception.printStackTrace();
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)gson.toJson((Object)error)).type("application/json");
        return builder.build();
    }
}

