/*
 * Decompiled with CFR 0.152.
 */
package inputs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;

public class PathInfo {
    private String name;
    private String fullName;
    private long length;
    private long spaceConsumed;
    private long numberOfFiles;
    private long numberOfSubDirectories;
    private boolean directory;
    private String message;
    private ArrayList<PathInfo> children;
    private boolean isCorrupt;
    private String pathLocation;
    private FsPermission fsPermissions;
    private String user;
    private String group;
    private BlockLocation[] blockLocation;
    private String rack;
    private long mtime;
    private long atime;
    private long ctime;
    private long blockSize;
    private AclStatus acl;
    Map<String, byte[]> xattr;

    public PathInfo() {
    }

    public PathInfo(String name, String fullName, boolean directory, long length, long spaceConsumed, long numberOfFiles, String message, String Location2) {
        this.name = name;
        this.fullName = fullName;
        this.directory = directory;
        this.length = length;
        this.spaceConsumed = spaceConsumed;
        this.numberOfFiles = numberOfFiles;
        this.message = message;
        this.pathLocation = Location2;
        this.isCorrupt = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public void setSpaceConsumed(long spaceConsumed) {
        this.spaceConsumed = spaceConsumed;
    }

    public long getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public void setNumberOfFiles(long numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public long getNumberOfSubDirectories() {
        return this.numberOfSubDirectories;
    }

    public void setNumberOfSubDirectories(long numberOfSubDirectories) {
        this.numberOfSubDirectories = numberOfSubDirectories;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ArrayList<PathInfo> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<PathInfo> children) {
        this.children = children;
    }

    public double getAverageReplicaCount() {
        return (double)this.getSpaceConsumed() / (double)this.getSpaceConsumed();
    }

    public double getAverageFileSize() {
        return this.getLength() / this.getNumberOfFiles();
    }

    public void setReplicationLocation(String Location2) {
        this.pathLocation = Location2;
    }

    public String getReplicationLocation() {
        return this.pathLocation;
    }

    public void setIsCorrupt(Boolean corruptionFlag) {
        this.isCorrupt = corruptionFlag;
    }

    public boolean getIsCorrupt() {
        return this.isCorrupt;
    }

    public void setPermissions(FsPermission permissions) {
        this.fsPermissions = permissions;
    }

    public FsPermission getPermissions() {
        return this.fsPermissions;
    }

    public void setUser(String User) {
        this.user = User;
    }

    public String getUser() {
        return this.user;
    }

    public void setGroup(String Location2) {
        this.group = Location2;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPathLocation() {
        return this.pathLocation;
    }

    public void setPathLocation(String pathLocation) {
        this.pathLocation = pathLocation;
    }

    public FsPermission getFsPermissions() {
        return this.fsPermissions;
    }

    public void setFsPermissions(FsPermission fsPermissions) {
        this.fsPermissions = fsPermissions;
    }

    public void setCorrupt(boolean isCorrupt) {
        this.isCorrupt = isCorrupt;
    }

    public BlockLocation[] getBlockLocation() {
        return this.blockLocation;
    }

    public void setBlockLocation(BlockLocation[] blockLocation) {
        this.blockLocation = blockLocation;
    }

    public String getRack() {
        return this.rack;
    }

    public void setRack(String rack) {
        this.rack = rack;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public long getAtime() {
        return this.atime;
    }

    public void setAtime(long atime) {
        this.atime = atime;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public void MinimizeBlockMap() throws IOException {
        if (this.blockLocation != null) {
            BlockLocation[] backup = (BlockLocation[])this.blockLocation.clone();
            this.blockLocation = new BlockLocation[backup.length];
            int index = 0;
            for (BlockLocation blk : backup) {
                BlockLocation blkLocation = new BlockLocation(blk.getNames(), blk.getHosts(), blk.getTopologyPaths(), blk.getOffset(), blk.getLength(), blk.isCorrupt());
                this.blockLocation[index++] = blkLocation;
            }
        }
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public AclStatus getAcl() {
        return this.acl;
    }

    public void setAcl(AclStatus acl) {
        this.acl = acl;
    }

    public Map<String, byte[]> getXattr() {
        return this.xattr;
    }

    public void setXattr(Map<String, byte[]> xattr) {
        this.xattr = xattr;
    }
}

