/*
 * Decompiled with CFR 0.152.
 */
package hbaseLibrary;

import com.github.gbraccialli.hdfs.DirectoryContentsUtils;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import configuration.IConfiguration;
import hbaseLibrary.HbaseIncremental;
import inputs.HbaseBackupInput;
import inputs.HbaseIncrInput;
import inputs.RestoreReq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupDriver;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreClientFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.RestoreClient;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.client.BackupAdmin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Logger;
import output.snapoutput;
import util.BoundedExponentialRetryCallable;
import util.KerberosUtil;
import util.StackTraceUtil;
import util.ThreadSleeper;

public class hbaseUtil {
    private static final String[] HBASE_CONFIG = new String[]{"hbase-policy.xml", "hbase-site.xml", "hbase-default.xml"};
    private static final String[] HADOOP_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml"};
    private static Connection connection;
    private static Configuration configuration;
    private static HBaseAdmin adm;
    private static BackupAdmin bkpAdm;
    private static volatile hbaseUtil tool;
    private static Logger log;
    private static Future<String> backupId;
    private static IConfiguration globalconfig;
    public static final String SNAP_PATH = ".hbase-snapshot";

    @Inject
    public hbaseUtil(IConfiguration config) throws Exception {
        File f;
        globalconfig = config;
        log.info((Object)"Getting driver meta data");
        configuration = new Configuration();
        System.setProperty("HBASE_USER_NAME", config.getHbaseUser());
        System.setProperty("HADOOP_USER_NAME", config.getHadoopUser());
        String hbaseConfigDir = config.getHbaseConfig();
        log.info((Object)("HBase user: " + (Strings.isNullOrEmpty((String)config.getHbaseUser()) ? "n/a" : config.getHbaseUser())));
        log.info((Object)("Hadoop user: " + (Strings.isNullOrEmpty((String)config.getHadoopUser()) ? "n/a" : config.getHadoopUser())));
        log.info((Object)("HBase config Dir: " + (Strings.isNullOrEmpty((String)config.getHbaseConfig()) ? "n/a" : config.getHbaseConfig())));
        log.info((Object)("Hadoop config Dir: " + (Strings.isNullOrEmpty((String)config.gethadoopConfDir()) ? "n/a" : config.gethadoopConfDir())));
        for (String file : HADOOP_CONF_FILES) {
            f = new File(config.gethadoopConfDir(), file);
            if (!f.exists()) continue;
            configuration.addResource(new Path(f.getAbsolutePath()));
            log.info((Object)(f.getAbsolutePath() + " added to resource list."));
        }
        for (String file : HBASE_CONFIG) {
            f = new File(hbaseConfigDir, file);
            if (!f.exists()) continue;
            configuration.addResource(new Path(f.getAbsolutePath()));
            log.info((Object)(f.getAbsolutePath() + " added to resource list"));
        }
        try {
            String strAuthentication = configuration.get("hbase.security.authentication");
            if (!Strings.isNullOrEmpty((String)strAuthentication) && strAuthentication.equalsIgnoreCase("kerberos")) {
                hbaseUtil.AuthKerberos();
            } else {
                UserGroupInformation.setConfiguration((Configuration)configuration);
            }
            connection = ConnectionFactory.createConnection((Configuration)configuration);
            adm = new HBaseAdmin(connection);
            bkpAdm = adm.getBackupAdmin();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
    }

    private static boolean testConnection() {
        if (tool == null) {
            return false;
        }
        return !connection.isClosed() && !adm.isAborted();
    }

    public static hbaseUtil initialize(IConfiguration config) throws Exception {
        tool = hbaseUtil.connect(config);
        return tool;
    }

    public static synchronized hbaseUtil connect(IConfiguration config) throws Exception {
        if (!hbaseUtil.testConnection()) {
            if (tool != null) {
                tool.close();
            }
        } else {
            return tool;
        }
        return hbaseUtil.createConnection(config);
    }

    private void close() throws IOException {
        bkpAdm.close();
        adm.close();
        connection.close();
        tool = null;
    }

    private static hbaseUtil createConnection(final IConfiguration config) throws Exception {
        if (tool != null) {
            try {
                tool.close();
            }
            catch (IOException e) {
                log.warn((Object)"Exception performing house cleaning -- closing current connection to jmx remote agent.");
                log.warn((Object)StackTraceUtil.getStackTrace(e));
            }
        }
        try {
            tool = (hbaseUtil)new BoundedExponentialRetryCallable<hbaseUtil>(){

                @Override
                public hbaseUtil retriableCall() throws Exception {
                    log.info((Object)"Creating hbase connection");
                    hbaseUtil nodetool = new hbaseUtil(config);
                    return nodetool;
                }
            }.call();
        }
        catch (Exception e) {
            log.error((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e.getMessage());
        }
        return tool;
    }

    public static hbaseUtil instance(IConfiguration config) throws Exception {
        if (!hbaseUtil.testConnection()) {
            tool = hbaseUtil.connect(config);
        }
        return tool;
    }

    private static void loadConf() throws Exception {
        configuration = new Configuration();
        System.setProperty("HBASE_USER_NAME", "hbase");
        String hbaseConfigDir = "/etc/hbase/conf";
        SaslRpcServer.AuthMethod authmethod = SaslRpcServer.AuthMethod.SIMPLE;
        for (String file : HBASE_CONFIG) {
            File f = new File(hbaseConfigDir, file);
            if (!f.exists()) continue;
            configuration.addResource(new Path(f.getAbsolutePath()));
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"hbase", (SaslRpcServer.AuthMethod)authmethod);
            User hbaseUser = User.create((UserGroupInformation)ugi);
            connection = ConnectionFactory.createConnection((Configuration)configuration, (User)hbaseUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
    }

    public static HTableDescriptor[] loaddbs() throws Exception {
        return adm.listTables();
    }

    public static List<List<HRegionInfo>> loaddbregions() throws Exception {
        HTableDescriptor[] tables = adm.listTables();
        ArrayList<List<HRegionInfo>> RegionInfo = new ArrayList<List<HRegionInfo>>();
        for (HTableDescriptor table : tables) {
            RegionInfo.add(adm.getTableRegions(table.getTableName()));
        }
        return RegionInfo;
    }

    private static void doBackup() throws Exception {
        try {
            log.info((Object)"Trying backup");
            BackupDriver bkpDriver = new BackupDriver();
            bkpDriver.setConf(configuration);
            TableName tbl = TableName.valueOf((String)"TestTable");
            ArrayList<TableName> tables = new ArrayList<TableName>();
            tables.add(tbl);
            BackupManager mgr = new BackupManager(configuration);
            BackupInfo bkpInfo = new BackupInfo();
            BackupAdmin backupAdmin = adm.getBackupAdmin();
            BackupRequest request = new BackupRequest();
            request.setBackupType(BackupType.valueOf((String)"FULL")).setTableList(tables).setTargetRootDir("hdfs://172.16.197.112:8020/tmp/backup_");
            log.info((Object)" Starting backup ");
            String backupId = backupAdmin.backupTables(request);
            log.info((Object)(" Backup ID [" + backupId + "}"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
    }

    public List<BackupInfo> doBackup(HbaseBackupInput bkpInput) throws Exception {
        String tableName;
        log.info((Object)"Trying backup");
        BackupDriver bkpDriver = new BackupDriver();
        bkpDriver.setConf(configuration);
        String namespace = bkpInput.getTable().split(":", 1)[0];
        String staging = bkpInput.getStaging() + "/" + bkpInput.getTable().replace(":", "~");
        log.info((Object)("Staging path " + staging));
        TableName tbl = TableName.valueOf((String)bkpInput.getTable());
        ArrayList<TableName> tables = new ArrayList<TableName>();
        tables.add(tbl);
        BackupManager mgr = new BackupManager(configuration);
        BackupInfo bkpInfo = new BackupInfo();
        BackupRequest request = new BackupRequest();
        request.setBackupType(BackupType.valueOf((String)bkpInput.getBkptype())).setTableList(tables).setTargetRootDir(staging);
        log.info((Object)" Starting backup program ");
        Future backupId = bkpAdm.backupTablesAsync(request);
        if (!bkpAdm.getHistory(1).isEmpty()) {
            log.info((Object)("Table Name as string " + ((BackupInfo)bkpAdm.getHistory(1).get(0)).getTableListAsString() + " " + bkpInput.getTable()));
        }
        if (!(tableName = ((BackupInfo)bkpAdm.getHistory(1).get(0)).getTableListAsString()).contains(":")) {
            tableName = "default:" + tableName;
        }
        int count = 50;
        while (tableName.compareToIgnoreCase(bkpInput.getTable()) != 0) {
            log.info((Object)("Table Didn't match " + tableName + " " + bkpInput.getTable()));
            ThreadSleeper sleeper = new ThreadSleeper();
            sleeper.sleep(10000L);
            tableName = ((BackupInfo)bkpAdm.getHistory(1).get(0)).getTableListAsString();
            if (!tableName.contains(":")) {
                tableName = "default:" + tableName;
            }
            if (--count != 0) continue;
            throw new IOException("Backup failed to start, please check the logs for more details");
        }
        return bkpAdm.getHistory(1);
    }

    public void doRestore(RestoreReq rstInput) throws Exception {
        log.info((Object)"Trying Restores");
        BackupDriver bkpDriver = new BackupDriver();
        bkpDriver.setConf(configuration);
        BackupManager mgr = new BackupManager(configuration);
        log.info((Object)" Starting restores ");
        rstInput.genTableNamesFromTables();
        rstInput.genTableNamesToTables();
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        hdfsDirUtil.ChangePermission(rstInput.getBackupRootDir(), globalconfig.getHbaseUser(), hdfsDirUtil.getFsObj().getFileStatus(new Path(configuration.get("hbase.rootdir"))).getOwner());
        System.setProperty("HADOOP_USER_NAME", globalconfig.getHbaseUser());
        RestoreClient client = BackupRestoreClientFactory.getRestoreClient((Configuration)configuration);
        try {
            client.restore(rstInput.getBackupRootDir(), rstInput.getBackupId(), rstInput.isCheck(), rstInput.getFromTables(), rstInput.getToTables(), rstInput.isOverwrite());
        }
        catch (Exception e) {
            log.info((Object)StackTraceUtil.getStackTrace(e));
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public void deleteBackup(String backupID) throws IOException {
        bkpAdm.deleteBackupSet(backupID);
    }

    public static int getProgress(String backupId) throws IOException {
        log.info((Object)(" Backup ID : " + backupId));
        return bkpAdm.getProgress(backupId);
    }

    public static BackupInfo getInfo(String backupId) throws IOException {
        log.info((Object)("Backup ID : " + backupId));
        BackupInfo bkpinfo = bkpAdm.getBackupInfo(backupId);
        log.info((Object)("Obtained backup info " + bkpinfo.getJobId()));
        return bkpAdm.getBackupInfo(backupId);
    }

    public static Long getDataDirSize() throws Exception {
        String dataDirectoty = connection.getConfiguration().get("hbase.rootdir") + "/data";
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        return DirectoryContentsUtils.getSize(dataDirectoty);
    }

    public static Long getLogDirSize() throws Exception {
        String dataDirectoty = connection.getConfiguration().get("hbase.rootdir") + "/oldWALs";
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        return DirectoryContentsUtils.getSize(dataDirectoty);
    }

    private static void mkdirRecurse(Path p) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        if (!hdfsDirUtil.getFsObj().exists(p.getParent())) {
            hbaseUtil.mkdirRecurse(p.getParent());
        }
        hdfsDirUtil.getFsObj().mkdirs(p);
        FileStatus fileStatus = hdfsDirUtil.getFsObj().getFileStatus(new Path(configuration.get("hbase.rootdir")));
        hdfsDirUtil.getFsObj().setOwner(p, globalconfig.getHbaseUser(), fileStatus.getOwner());
    }

    public static snapoutput snapshot(HbaseBackupInput input) throws Exception {
        try {
            String Table;
            String Namespace;
            log.info((Object)"Snap backup");
            SnapshotManager mgr = new SnapshotManager();
            HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.getDefaultInstance();
            if (input.getTable().contains(":")) {
                Namespace = input.getTable().split(":")[0];
                Table = input.getTable().split(":")[1];
            } else {
                Namespace = "default";
                Table = input.getTable();
                input.setTable(Namespace + ":" + Table);
            }
            String SnapName = Namespace + "_" + Table + "_" + Time.now();
            String staging = Path.mergePaths((Path)new Path(input.getStaging()), (Path)new Path("/" + Namespace + "~" + Table + "/" + SnapName + "/")).toString();
            adm.snapshot(SnapName, input.getTable());
            if (input.getJrDir() != null && input.getCollectID() != null) {
                hbaseUtil.generateCollectFiles(input.getCollectID(), input.getJrDir(), SnapName, Namespace, Table);
            } else {
                Path StagingPath = new Path(staging);
                log.info((Object)StagingPath.toUri().toString());
                String[] cmdArgs = ("-snapshot " + SnapName + " -copy-to " + StagingPath.toUri()).split(" ");
                hbaseUtil.mkdirRecurse(StagingPath);
                ExportSnapshot exp = new ExportSnapshot();
                exp.setConf(configuration);
                exp.run(cmdArgs);
                adm.deleteSnapshot(SnapName);
            }
            HBaseProtos.SnapshotDescription snapdesc = (HBaseProtos.SnapshotDescription)adm.listSnapshots(SnapName).get(0);
            snapoutput output = new snapoutput(snapdesc.getName(), snapdesc.getCreationTime(), snapdesc.getTable(), snapdesc.getVersion(), staging);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)StackTraceUtil.getStackTrace(e));
            throw new Exception(e);
        }
    }

    private static void generateCollectFiles(String collectID, String jrDir, String snapName, String namespace, String tableName) throws Exception {
        String snapPath = configuration.get("hbase.rootdir");
        String pathStr = "/.hbase-snapshot/" + snapName;
        Path workingDir = Path.mergePaths((Path)new Path(snapPath), (Path)new Path(pathStr));
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        HBaseProtos.SnapshotDescription snapdesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)hdfsDirUtil.getFsObj(), (Path)workingDir);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)configuration, (FileSystem)hdfsDirUtil.getFsObj(), (Path)workingDir, (HBaseProtos.SnapshotDescription)snapdesc);
        FileWriter fWriter = new FileWriter(collectID);
        BufferedWriter writer = new BufferedWriter(fWriter);
        String TableString = namespace + "~" + tableName + "~" + snapName;
        hbaseUtil.WriteData(hdfsDirUtil, writer, workingDir.getParent(), TableString);
        hbaseUtil.WriteData(hdfsDirUtil, writer, workingDir.getParent(), TableString);
        hbaseUtil.WriteData(hdfsDirUtil, writer, Path.mergePaths((Path)workingDir, (Path)new Path("/.snapshotinfo")), TableString);
        hbaseUtil.WriteData(hdfsDirUtil, writer, Path.mergePaths((Path)workingDir, (Path)new Path("/data.manifest")), TableString);
        for (Map.Entry manifestIter : manifest.getRegionManifestsMap().entrySet()) {
            String location = snapPath + "/archive/data/" + namespace + "/" + tableName + "/" + (String)manifestIter.getKey();
            Path actualDir = Path.mergePaths((Path)new Path(snapPath), (Path)new Path("/data/" + namespace + "/" + tableName + "/" + (String)manifestIter.getKey()));
            Path archiveDir = new Path(location);
            hbaseUtil.WriteData(hdfsDirUtil, writer, new Path("/"), TableString);
            hbaseUtil.WriteData(hdfsDirUtil, writer, new Path(snapPath), TableString);
            hbaseUtil.WriteData(hdfsDirUtil, writer, actualDir, TableString);
            for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : ((SnapshotProtos.SnapshotRegionManifest)manifestIter.getValue()).getFamilyFilesList()) {
                Path actualHFileDir = Path.mergePaths((Path)actualDir, (Path)new Path("/" + familyFiles.getFamilyName().toStringUtf8() + "/"));
                Path archiveHFileDir = Path.mergePaths((Path)archiveDir, (Path)new Path("/" + familyFiles.getFamilyName().toStringUtf8() + "/"));
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile storefile : familyFiles.getStoreFilesList()) {
                    if (hdfsDirUtil.getFsObj().exists(Path.mergePaths((Path)actualHFileDir, (Path)new Path("/" + storefile.getName())))) {
                        log.info((Object)("File exists" + Path.mergePaths((Path)actualHFileDir, (Path)new Path("/" + storefile.getName())).toString()));
                        if (HFileLink.isHFileLink((Path)Path.mergePaths((Path)actualHFileDir, (Path)new Path("/" + storefile.getName())))) {
                            Path hfileLinkPath = Path.mergePaths((Path)actualHFileDir, (Path)new Path("/" + storefile.getName()));
                            String family = hfileLinkPath.getParent().getName();
                            TableName table = HFileLink.getReferencedTableName((String)hfileLinkPath.getName());
                            String region = HFileLink.getReferencedRegionName((String)hfileLinkPath.getName());
                            String hfile = HFileLink.getReferencedHFileName((String)hfileLinkPath.getName());
                            log.info((Object)("Table name: " + table));
                            String archivedLocation = snapPath + "/" + "archive" + "/data/" + table.getNamespaceAsString() + "/" + table.getQualifierAsString() + "/" + region + "/" + family + "/" + hfile;
                            Path archivePath = new Path(archivedLocation);
                            if (!hdfsDirUtil.getFsObj().exists(archivePath)) {
                                log.info((Object)("File might be a link: " + archiveHFileDir.toString()));
                                String LinkArchivedLocation = snapPath + "/" + "archive" + "/data/" + table.getNamespaceAsString() + "/" + table.getQualifierAsString() + "/" + region + "/" + family + "/.links-" + hfile;
                                log.info((Object)("Link location: " + LinkArchivedLocation));
                                if (hdfsDirUtil.getFsObj().exists(new Path(LinkArchivedLocation))) {
                                    String ActualMovedPath = snapPath + "/data/" + table.getNamespaceAsString() + "/" + table.getQualifierAsString() + "/" + region + "/" + family + "/" + hfile;
                                    archivePath = new Path(ActualMovedPath);
                                }
                            }
                            hbaseUtil.WriteData(hdfsDirUtil, writer, archivePath, TableString);
                            continue;
                        }
                        hbaseUtil.WriteData(hdfsDirUtil, writer, Path.mergePaths((Path)actualHFileDir, (Path)new Path("/" + storefile.getName())), TableString);
                        continue;
                    }
                    hbaseUtil.WriteData(hdfsDirUtil, writer, Path.mergePaths((Path)archiveHFileDir, (Path)new Path("/" + storefile.getName())), TableString);
                }
            }
        }
        writer.flush();
        writer.close();
    }

    public static void WriteData(DirectoryContentsUtils hdfsUtil, BufferedWriter writer, Path writeThis, String TableString) throws IOException {
        FileStatus status = hdfsUtil.getFsObj().getFileStatus(writeThis);
        String Entry2 = status.isFile() ? "%??HBASESNAP%" + Path.getPathWithoutSchemeAndAuthority((Path)writeThis).toString() + ":" + TableString + "|" + status.getLen() : "%??HBASESNAP%" + Path.getPathWithoutSchemeAndAuthority((Path)writeThis).toString() + ":" + TableString;
        writer.write(Entry2);
        writer.newLine();
    }

    public static String getDataDir() {
        return Path.getPathWithoutSchemeAndAuthority((Path)new Path(configuration.get("hbase.rootdir"))).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void restoreSnap(RestoreReq rstInput) throws Exception {
        rstInput.genTableNamesFromTables();
        rstInput.genTableNamesToTables();
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        Path hbaseRootDir = new Path(configuration.get("hbase.rootdir"));
        FileStatus hbaseRootDirStatus = hdfsDirUtil.getFsObj().getFileStatus(hbaseRootDir);
        Path archivePath = Path.mergePaths((Path)hbaseRootDir, (Path)new Path("/archive/data/" + rstInput.getFromTablesNames()[0].replace(":", "/")));
        log.info((Object)("ArchivePath " + archivePath.toString()));
        if (hdfsDirUtil.getFsObj().exists(archivePath)) {
            log.info((Object)("Changing ownership for " + archivePath.toString() + " to " + hbaseRootDirStatus.getOwner() + ":" + hbaseRootDirStatus.getGroup()));
            hdfsDirUtil.getFsObj().setOwner(archivePath, hbaseRootDirStatus.getOwner(), hbaseRootDirStatus.getGroup());
            hdfsDirUtil.ChangePermission(archivePath.toString(), hbaseRootDirStatus.getOwner(), hbaseRootDirStatus.getGroup());
        }
        Path snapPath = Path.mergePaths((Path)hbaseRootDir, (Path)new Path("/.hbase-snapshot/" + rstInput.getBackupId()));
        log.info((Object)("SnapPath " + snapPath.toString()));
        if (hdfsDirUtil.getFsObj().exists(snapPath)) {
            log.info((Object)("Changing ownership for " + snapPath.toString() + " to " + hbaseRootDirStatus.getOwner() + ":" + hbaseRootDirStatus.getGroup()));
            hdfsDirUtil.getFsObj().setOwner(snapPath, hbaseRootDirStatus.getOwner(), hbaseRootDirStatus.getGroup());
            hdfsDirUtil.ChangePermission(snapPath.toString(), hbaseRootDirStatus.getOwner(), hbaseRootDirStatus.getGroup());
        }
        if (rstInput.getToTables() != null && rstInput.getToTables().length != 0) {
            log.info((Object)"Restore to Different DB");
            if (adm.tableExists(rstInput.getToTables()[0])) {
                if (!rstInput.isOverwrite()) throw new Exception("Table " + rstInput.getToTables()[0] + " exists. Overwrite option not selected");
                log.info((Object)("Restore to " + rstInput.getToTables()[0]));
                if (!adm.isTableDisabled(rstInput.getToTables()[0])) {
                    adm.disableTable(rstInput.getToTables()[0]);
                }
                adm.deleteTable(rstInput.getToTables()[0]);
            } else {
                try {
                    NamespaceDescriptor namespaceDescriptor = adm.getNamespaceDescriptor(rstInput.getToTables()[0].getNamespaceAsString());
                }
                catch (NamespaceNotFoundException e) {
                    NamespaceDescriptor desc = NamespaceDescriptor.create((String)rstInput.getToTables()[0].getNamespaceAsString()).build();
                    adm.createNamespace(desc);
                }
            }
            boolean bUseHbaseShell = rstInput.getUseHBaseShell();
            boolean bDeleteTable = false;
            if (!bUseHbaseShell) {
                try {
                    adm.cloneSnapshot(rstInput.getBackupId(), rstInput.getToTables()[0], true);
                }
                catch (Exception e) {
                    log.info((Object)"cloneSnapshot failed");
                    bDeleteTable = true;
                    bUseHbaseShell = true;
                }
            }
            if (bUseHbaseShell) {
                if (bDeleteTable) {
                    hbaseUtil.DropTable(rstInput.getToTables()[0]);
                }
                String cmd = "echo \"clone_snapshot '" + rstInput.getBackupId() + "','" + rstInput.getToTables()[0] + "'\" |  hbase shell -n";
                log.info((Object)("Running command: " + cmd));
                String[] outAnderr = new String[2];
                hbaseUtil.RunOScommand(cmd, outAnderr);
                log.info((Object)("out: " + outAnderr[0] + " err: " + outAnderr[1]));
            }
        } else {
            log.info((Object)"Restore to same DB");
            if (adm.tableExists(rstInput.getToTables()[0])) {
                if (!rstInput.isOverwrite()) throw new Exception("Table " + rstInput.getToTables()[0] + " exists. Overwrite option not selected");
                log.info((Object)("Restore to " + rstInput.getToTables()[0]));
                if (!adm.isTableDisabled(rstInput.getToTables()[0])) {
                    adm.disableTable(rstInput.getToTables()[0]);
                }
                adm.deleteTable(rstInput.getToTables()[0]);
            }
            boolean bUseHbaseShell = rstInput.getUseHBaseShell();
            boolean bDeleteTable = false;
            if (!bUseHbaseShell) {
                try {
                    adm.restoreSnapshot(rstInput.getBackupId(), false, true);
                }
                catch (Exception e) {
                    log.info((Object)"restoreSnapshot failed");
                    bDeleteTable = true;
                    bUseHbaseShell = true;
                }
            }
            if (bUseHbaseShell) {
                if (bDeleteTable) {
                    hbaseUtil.DropTable(rstInput.getToTables()[0]);
                }
                String cmd = "echo \"restore_snapshot '" + rstInput.getBackupId() + "'\" |  hbase shell -n";
                log.info((Object)("Running command: " + cmd));
                String[] outAnderr = new String[2];
                hbaseUtil.RunOScommand(cmd, outAnderr);
                log.info((Object)("out: " + outAnderr[0] + " err: " + outAnderr[1]));
            }
        }
        adm.deleteSnapshot(rstInput.getBackupId());
    }

    public static void DropTable(TableName table) throws Exception {
        String cmd = "echo \"disable '" + table + "'\" |  hbase shell -n";
        log.info((Object)("Running command: " + cmd));
        String[] outAnderr = new String[2];
        hbaseUtil.RunOScommand(cmd, outAnderr);
        log.info((Object)("out: " + outAnderr[0] + " err: " + outAnderr[1]));
        cmd = "echo \"drop '" + table + "'\" |  hbase shell -n";
        log.info((Object)("Running command: " + cmd));
        hbaseUtil.RunOScommand(cmd, outAnderr);
        log.info((Object)("out: " + outAnderr[0] + " err: " + outAnderr[1]));
    }

    public static void RunOScommand(String cmd, String[] outAnderr) throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
        process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        outAnderr[0] = "";
        outAnderr[1] = "";
        while ((line = reader.readLine()) != null) {
            outAnderr[0] = outAnderr[0] + line;
        }
        reader.close();
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = errorReader.readLine()) != null) {
            outAnderr[1] = outAnderr[1] + line;
        }
        errorReader.close();
    }

    public static void restoreIncr(RestoreReq rstInput) throws Exception {
        rstInput.genTableNamesFromTables();
        rstInput.genTableNamesToTables();
        TableName TableToRestore = rstInput.getToTablesNames() != null && rstInput.getToTablesNames().length != 0 ? rstInput.getToTables()[0] : rstInput.getFromTables()[0];
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        log.info((Object)("Staging location" + rstInput.getBackupRootDir().toString()));
        Path BackupRoot = new Path(rstInput.getBackupRootDir(), rstInput.getFromTablesNames()[0].replace(":", "~"));
        String user = hdfsDirUtil.getFsObj().getFileStatus(new Path(configuration.get("hbase.rootdir"))).getOwner();
        String group = hdfsDirUtil.getFsObj().getFileStatus(new Path(configuration.get("hbase.rootdir"))).getGroup();
        if (!hdfsDirUtil.getFsObj().exists(BackupRoot)) {
            log.info((Object)("There is no incremental data to restore for " + rstInput.getFromTablesNames()[0]));
            return;
        }
        hdfsDirUtil.getFsObj().setOwner(BackupRoot, user, group);
        hdfsDirUtil.ChangePermission(BackupRoot.toString(), user, group);
        HashSet<String> Paths2 = new HashSet<String>();
        RemoteIterator fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(BackupRoot, true);
        while (fileStatusListIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            if (!fileStatus.isFile() || fileStatus.getPath().getName() == "_SUCCESS") continue;
            Paths2.add(fileStatus.getPath().getParent().getParent().toString());
        }
        String strAuthentication = configuration.get("hbase.security.authentication");
        if (!Strings.isNullOrEmpty((String)strAuthentication) && strAuthentication.equalsIgnoreCase("kerberos")) {
            hbaseUtil.AuthKerberos();
        }
        for (String IncrPaths : Paths2) {
            log.info((Object)("Incremental Path " + IncrPaths));
            LoadIncrementalHFiles blkLoadObj = new LoadIncrementalHFiles(configuration);
            blkLoadObj.run(IncrPaths, null, TableToRestore);
        }
    }

    public void deleteSnap(String snapID) throws IOException {
        adm.deleteSnapshot(snapID);
    }

    public static snapoutput WalPlayer(HbaseIncrInput input) throws Exception {
        log.info((Object)"WAl player api");
        HbaseIncremental.globalconfig = globalconfig;
        HbaseIncremental.configuration = configuration;
        return HbaseIncremental.ProcessLogs(input);
    }

    public void flushAllTables() throws Exception {
        log.info((Object)"Flushing all Tables");
        for (HTableDescriptor tables : adm.listTables()) {
            log.info((Object)tables.getTableName());
            adm.flush(tables.getTableName());
        }
    }

    public static void main(String[] args) {
        try {
            hbaseUtil.loadConf();
        }
        catch (Exception e) {
            log.info((Object)StackTraceUtil.getStackTrace(e));
            e.printStackTrace();
        }
    }

    public static void AuthKerberos() throws Exception {
        log.info((Object)"Kerberos auth detected");
        InetAddress ip = InetAddress.getLocalHost();
        log.info((Object)("Hostname: " + ip.getHostName()));
        String keyTabLocation = null;
        if (configuration.get("hbase.client.keytab.file") != null) {
            keyTabLocation = configuration.get("hbase.client.keytab.file");
        }
        if (Strings.isNullOrEmpty(keyTabLocation)) {
            log.info((Object)"Couldn't find the required key from the configuration, using the commvault config file");
            keyTabLocation = globalconfig.GetKeytabLocation();
            if (Strings.isNullOrEmpty((String)keyTabLocation)) {
                throw new Exception("Failed to get keytab location using hbase.client.keytab.file");
            }
        }
        String principal = globalconfig.getHbaseUser();
        log.debug((Object)("Principal: " + principal.replaceFirst("/_HOST.*", "")));
        log.debug((Object)("Keytab: " + keyTabLocation));
        try {
            if (!KerberosUtil.Login(principal, keyTabLocation, configuration).booleanValue()) {
                log.info((Object)"Failed to login. All attempts failed");
            }
        }
        catch (Exception e) {
            log.info((Object)"Failed to login. All attempts failed");
            log.info((Object)StackTraceUtil.getStackTrace(e));
        }
    }

    static {
        tool = null;
        log = Logger.getLogger(hbaseUtil.class);
    }
}

