/*
 * Decompiled with CFR 0.152.
 */
package hbaseLibrary;

import com.github.gbraccialli.hdfs.DirectoryContentsUtils;
import configuration.IConfiguration;
import configuration.PropertiesConfigSource;
import configuration.UtilConfig;
import hbaseLibrary.hbaseUtil;
import inputs.HbaseIncrInput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import output.snapoutput;

public class HbaseIncremental {
    private static final String[] HBASE_CONFIG = new String[]{"hbase-policy.xml", "hbase-site.xml", "hbase-default.xml"};
    private static final String[] HADOOP_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml"};
    public static final String DATA_MANIFEST_NAME = "data.manifest";
    private static Logger log = Logger.getLogger(HbaseIncremental.class);
    public static Boolean writeData = false;
    public static IConfiguration globalconfig;
    public static Configuration configuration;
    private static String bulkOutputConfKey;

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)Paths.get(System.getProperty("cvutil.config.file"), "cvhadooplog4j.properties").toAbsolutePath().toString());
        Boolean writeData = false;
        String tableName = null;
        Long startTimeStamp = new Long(0L);
        String outputLocation = null;
        String oldWALs = null;
        Object WAL = null;
        for (String arg : args) {
            if (arg.startsWith("--writeMeta")) {
                writeData = true;
                continue;
            }
            if (arg.startsWith("--TableName=")) {
                tableName = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith("--time=")) {
                System.out.println(arg);
                System.out.println(arg.split("=")[1]);
                startTimeStamp = Long.parseLong(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--output=")) {
                outputLocation = arg.split("=")[1];
                continue;
            }
            if (!arg.startsWith("--oldWAL=")) continue;
            oldWALs = arg.split("=")[1];
        }
        System.out.println("Getting driver meta data");
        Configuration configuration = new Configuration();
        System.setProperty("HBASE_USER_NAME", "hbase");
        String hbaseConfigDir = "/etc/hbase/conf";
        for (String file : HBASE_CONFIG) {
            File f = new File(hbaseConfigDir, file);
            if (!f.exists()) continue;
            configuration.addResource(new Path(f.getAbsolutePath()));
        }
        String hadoopConfDir = "/etc/hadoop/conf";
        String file1 = "mapred-site.xml";
        File f1 = new File(hadoopConfDir, file1);
        if (f1.exists()) {
            configuration.addResource(new Path(f1.getAbsolutePath()));
        }
        try {
            SaslRpcServer.AuthMethod authmethod = SaslRpcServer.AuthMethod.SIMPLE;
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"hbase", (SaslRpcServer.AuthMethod)authmethod);
            if (UserGroupInformation.isSecurityEnabled()) {
                System.out.println("Login enabled");
            }
            User user = User.create((UserGroupInformation)ugi);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        UtilConfig globalconfig = new UtilConfig(new PropertiesConfigSource());
        System.setProperty("HADOOP_USER_NAME", "hbase");
        System.out.println("Starting the WAL player");
        String bulkOutputConfKey = "wal.bulk.output";
        WALPlayer player = new WALPlayer();
        player.setConf(configuration);
        TableName tbl = TableName.valueOf((String)tableName);
        configuration.set(bulkOutputConfKey, outputLocation);
        configuration.set("wal.input.separator", ";");
        configuration.set("hbase.fs.tmp.dir", "/tmp");
        DirectoryContentsUtils hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        Path oldWAL = new Path(oldWALs);
        RemoteIterator fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(oldWAL, true);
        String walList = "";
        Boolean first = true;
        System.out.println("TimeStamp [ " + startTimeStamp + "]");
        System.out.println("OLDWal [ " + oldWALs);
        Long largestTime = new Long(0L);
        while (fileStatusListIterator.hasNext()) {
            Long timestamp;
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            String extension = fileStatus.getPath().getName().substring(fileStatus.getPath().getName().lastIndexOf(".") + 1);
            if (!extension.matches("[0-9]*") || (timestamp = Long.valueOf(Long.parseLong(fileStatus.getPath().getName().substring(fileStatus.getPath().getName().lastIndexOf(".") + 1)))) <= startTimeStamp) continue;
            if (!first.booleanValue()) {
                walList = walList + ";";
            } else {
                first = false;
            }
            System.out.println("WAL found");
            System.out.println(fileStatus.getPath().toString());
            walList = walList + fileStatus.getPath().toString();
            largestTime = largestTime < timestamp ? largestTime : timestamp;
        }
        System.out.println("WalList [" + walList + "] [" + tbl.getNameAsString() + "]");
        String[] playerArgs = new String[]{walList, tbl.getNameAsString()};
        player.run(playerArgs);
    }

    public static snapoutput ProcessLogs(HbaseIncrInput input) throws Exception {
        hbaseUtil fos;
        String tableName = null;
        String Namespace = null;
        String tbl = null;
        if (!input.getTablename().contains(":")) {
            Namespace = "default";
            tbl = tableName = input.getTablename();
        } else {
            Namespace = input.getTablename().split(":")[0];
            tableName = input.getTablename().split(":")[1];
            tbl = Namespace.compareTo("default") == 0 ? tableName : Namespace + ":" + tableName;
            log.info((Object)("Namespace [" + Namespace + "] [" + tableName + "] [" + tbl + "]"));
        }
        log.info((Object)("Start time  " + input.getStarttimestamp()));
        configuration.setLong("wal.start.time", input.getStarttimestamp().longValue());
        String walList = "";
        Long largestTime = new Long(0L);
        if (input.getLastTimestamp() != null) {
            largestTime = Long.valueOf(input.getLastTimestamp());
            log.info((Object)("Largest time " + largestTime));
        }
        if (input.getLogCollectFile() == null) {
            input.setLogCollectFile(Paths.get(input.getJrdir(), "logCollect_" + input.starttimestamp).toString());
            FileWriter fWriter = new FileWriter(input.getLogCollectFile());
            BufferedWriter writer = new BufferedWriter(fWriter);
            DirectoryContentsUtils hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
            Path oldWAL = Path.mergePaths((Path)new Path(configuration.get("hbase.rootdir")), (Path)new Path("/oldWALs"));
            Boolean first = true;
            log.info((Object)("TimeStamp [ " + input.starttimestamp + "]"));
            log.info((Object)("OLDWal [ " + oldWAL.toString() + "]"));
            HbaseIncremental.CopyWALsToOld(input.outputlocation);
            for (int i = 0; i < 2; ++i) {
                RemoteIterator fileStatusListIterator = null;
                if (i == 0) {
                    fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(oldWAL, true);
                } else {
                    Path tmpOldWal = Path.mergePaths((Path)new Path(input.outputlocation), (Path)new Path("/oldWALs"));
                    fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(tmpOldWal, true);
                }
                System.setProperty("HBASE_USER_NAME", globalconfig.getHbaseUser());
                while (fileStatusListIterator.hasNext()) {
                    LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
                    String extension = fileStatus.getPath().getName().substring(fileStatus.getPath().getName().lastIndexOf(".") + 1);
                    if (!extension.matches("[0-9]*")) continue;
                    log.debug((Object)("Extension [" + extension + "]"));
                    Long timestamp = Long.parseLong(fileStatus.getPath().getName().substring(fileStatus.getPath().getName().lastIndexOf(".") + 1));
                    log.debug((Object)("Timestamp on file [" + timestamp + "]"));
                    if (i != 1 && timestamp < input.leastTime) continue;
                    if (!first.booleanValue()) {
                        walList = walList + ";";
                    } else {
                        first = false;
                    }
                    log.debug((Object)"WAL found");
                    log.debug((Object)fileStatus.getPath().toString());
                    walList = walList + fileStatus.getPath().toString();
                    writer.write(fileStatus.getPath().toString());
                    writer.newLine();
                    if (i == 1) continue;
                    largestTime = largestTime > timestamp ? largestTime : timestamp;
                }
            }
            largestTime = largestTime == 0L ? input.getLeastTime() : largestTime;
            writer.flush();
            writer.close();
        } else {
            walList = FileUtils.readFileToString((File)new File(input.getLogCollectFile()));
            walList = walList.replaceAll(System.lineSeparator(), ";");
        }
        DirectoryContentsUtils hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        String backupID = "backup_" + largestTime.toString();
        log.info((Object)"New output mapper");
        String outputLocation = new Path(input.outputlocation, new Path(Namespace + "~" + tableName, backupID)).toString();
        log.info((Object)("Output location: [" + outputLocation + "]"));
        configuration.set(bulkOutputConfKey, outputLocation);
        configuration.set("wal.input.separator", ";");
        configuration.set("hbase.fs.tmp.dir", configuration.get("hbase.rootdir") + "/.tmp");
        configuration.set("yarn.app.mapreduce.am.staging-dir", configuration.get("hbase.rootdir") + "/.staging");
        WALPlayer player = new WALPlayer();
        player.setConf(configuration);
        log.info((Object)("WalList [" + walList + "]"));
        if (walList.isEmpty()) {
            log.info((Object)"Empty, no logs to process");
            HbaseIncremental.mkdirRecurse(new Path(outputLocation));
            fos = hdfsDirUtil.getFsObj().create(Path.mergePaths((Path)new Path(outputLocation), (Path)new Path("/_SUCCESS")), true);
            fos.close();
        } else {
            if (configuration.get("hbase.security.authentication").equalsIgnoreCase("kerberos")) {
                fos = new hbaseUtil(globalconfig);
            }
            log.info((Object)("Running log player [" + tbl + "]"));
            String[] playerArgs = new String[]{walList, tbl};
            player.run(playerArgs);
            if (!hdfsDirUtil.getFsObj().exists(Path.mergePaths((Path)new Path(outputLocation), (Path)new Path("/_SUCCESS")))) {
                throw new Exception("Failed to run the incremental backup, please check hadoop logs for details");
            }
        }
        HbaseIncremental.generateCollects(new Path(outputLocation), input.getCollectFile(), Namespace + "~" + tableName);
        snapoutput walPlayerOutput = new snapoutput(backupID, largestTime, input.getTablename(), 2, input.getOutputlocation());
        walPlayerOutput.setLogCollectFile(input.getLogCollectFile());
        return walPlayerOutput;
    }

    private static void generateCollects(Path outputLocation, String collectFile, String TableString) throws Exception {
        log.info((Object)("Starting the process to write collect files... " + collectFile));
        FileWriter fWriter = new FileWriter(collectFile);
        BufferedWriter writer = new BufferedWriter(fWriter);
        DirectoryContentsUtils hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        HbaseIncremental.WriteData(hdfsDirUtil, writer, hdfsDirUtil.getFsObj().getFileStatus(outputLocation), TableString);
        RemoteIterator fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(outputLocation, true);
        while (fileStatusListIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            HbaseIncremental.WriteData(hdfsDirUtil, writer, (FileStatus)fileStatus, TableString);
        }
        writer.flush();
        writer.close();
    }

    private static void CopyWALsToOld(String outputLocation) throws Exception {
        log.info((Object)"Copying old files to new location");
        DirectoryContentsUtils hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        Path oldWAL = Path.mergePaths((Path)new Path(outputLocation), (Path)new Path("/oldWALs"));
        HbaseIncremental.mkdirRecurse(oldWAL);
        Path WAL = Path.mergePaths((Path)new Path(configuration.get("hbase.rootdir")), (Path)new Path("/WALs"));
        RemoteIterator fileStatusListIterator = hdfsDirUtil.getFsObj().listFiles(WAL, true);
        while (fileStatusListIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            log.info((Object)("Copying " + fileStatus.getPath().toString() + " to " + oldWAL.toString()));
            FileUtil.copy((FileSystem)hdfsDirUtil.getFsObj(), (Path)fileStatus.getPath(), (FileSystem)hdfsDirUtil.getFsObj(), (Path)oldWAL, (boolean)false, (Configuration)configuration);
        }
    }

    public static void WriteData(DirectoryContentsUtils hdfsUtil, BufferedWriter writer, FileStatus writeThis, String TableString) throws IOException {
        String Entry2 = writeThis.isFile() ? "%??HBASESNAPINCR%" + Path.getPathWithoutSchemeAndAuthority((Path)writeThis.getPath()).toString() + ":" + TableString + "|" + writeThis.getLen() : "%??HBASESNAPINCR%" + Path.getPathWithoutSchemeAndAuthority((Path)writeThis.getPath()).toString() + ":" + TableString;
        log.info((Object)("Entry" + Entry2));
        writer.write(Entry2);
        writer.newLine();
        writer.flush();
    }

    private static void mkdirRecurse(Path p) throws Exception {
        DirectoryContentsUtils hdfsDirUtil = null;
        hdfsDirUtil = DirectoryContentsUtils.instance(globalconfig);
        if (!hdfsDirUtil.getFsObj().exists(p.getParent())) {
            HbaseIncremental.mkdirRecurse(p.getParent());
        }
        hdfsDirUtil.getFsObj().mkdirs(p);
        FileStatus fileStatus = hdfsDirUtil.getFsObj().getFileStatus(new Path(configuration.get("hbase.rootdir")));
        hdfsDirUtil.getFsObj().setOwner(p, globalconfig.getHbaseUser(), fileStatus.getOwner());
        FsPermission permission = new FsPermission("775");
        hdfsDirUtil.getFsObj().setPermission(p, permission);
    }

    static {
        bulkOutputConfKey = "wal.bulk.output";
    }
}

