/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.google.inject.Inject;
import configuration.IConfigSource;
import configuration.IConfiguration;
import org.apache.log4j.Logger;

public class UtilConfig
implements IConfiguration {
    public static final String UTIL_PRE = "util";
    private final IConfigSource config;
    private static final Logger logger = Logger.getLogger(UtilConfig.class);
    private static final String CONFIG_HADOOP_CONFIG = "util.hadoop.config";
    private static final String CONFIG_HADOOP_USER = "util.hadoop.user";
    private static final String CONFIG_HBASE_USER = "util.hbase.user";
    private static final String CONFIG_HBASE_CONFIG = "util.hbase.config";
    private static final String CONFIG_HBASE_CONFIG_RETRY_COUNT = "util.hbase.backup.waitcount";
    private static final String COFNIG_HADOOP_URI = "util.hadoop.uri";
    private static final String COFNIG_HADOOP_CONCAT_WAIT_TIME = "util.hadoop.wait.time";
    private static final String COFNIG_HADOOP_KERBEROS_TICKET = "util.hadoop.security.kerberos.ticket.cache.path";
    private static final String COFNIG_HBASE_KEYTAB = "util.hbase.keytab";

    @Inject
    public UtilConfig(IConfigSource config) {
        this.config = config;
        this.intialize();
    }

    @Override
    public void intialize() {
        logger.info((Object)"intialize Config ");
        this.config.intialize();
    }

    @Override
    public String gethadoopConfDir() {
        return this.config.get(CONFIG_HADOOP_CONFIG, "/etc/hadoop/conf");
    }

    @Override
    public String getHadoopUser() {
        return this.config.get(CONFIG_HADOOP_USER, "hdfs");
    }

    @Override
    public String getHbaseUser() {
        return this.config.get(CONFIG_HBASE_USER, "hbase");
    }

    @Override
    public String getHbaseConfig() {
        return this.config.get(CONFIG_HBASE_CONFIG, "/etc/hbase/conf");
    }

    @Override
    public int getRetryCount() {
        return this.config.get(CONFIG_HBASE_CONFIG_RETRY_COUNT, 10);
    }

    @Override
    public String gethadoopURI() {
        return this.config.get(COFNIG_HADOOP_URI, "");
    }

    @Override
    public String GetKeytabLocation() {
        return this.config.get(COFNIG_HBASE_KEYTAB, "");
    }

    @Override
    public int getWaitTime() {
        return this.config.get(COFNIG_HADOOP_CONCAT_WAIT_TIME, 10);
    }

    @Override
    public String getKerberosTicket() {
        return this.config.get(COFNIG_HADOOP_KERBEROS_TICKET, "");
    }
}

